:- prim(expression, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgExpression($0)")
,let('SgNode*', $1, "isSgExpression($0)->get_type()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgExpression']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(binaryOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgBinaryOp($0)")
,let('SgNode*', $1, "isSgBinaryOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgBinaryOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgBinaryOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(addOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgAddOp($0)")
,let('SgNode*', $1, "isSgAddOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgAddOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgAddOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(addAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgPlusAssignOp($0)")
,let('SgNode*', $1, "isSgPlusAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgPlusAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgPlusAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(logicalAndOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgAndOp($0)")
,let('SgNode*', $1, "isSgAndOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgAndOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgAndOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(arrowOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgArrowExp($0)")
,let('SgNode*', $1, "isSgArrowExp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgArrowExp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgArrowExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(arrowStarOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgArrowStarOp($0)")
,let('SgNode*', $1, "isSgArrowStarOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgArrowStarOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgArrowStarOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(assignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgAssignOp($0)")
,let('SgNode*', $1, "isSgAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseAndOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgBitAndOp($0)")
,let('SgNode*', $1, "isSgBitAndOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgBitAndOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgBitAndOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseOrOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgBitOrOp($0)")
,let('SgNode*', $1, "isSgBitOrOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgBitOrOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgBitOrOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseXorOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgBitXorOp($0)")
,let('SgNode*', $1, "isSgBitXorOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgBitXorOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgBitXorOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseAndAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgAndAssignOp($0)")
,let('SgNode*', $1, "isSgAndAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgAndAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgAndAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseOrAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgIorAssignOp($0)")
,let('SgNode*', $1, "isSgIorAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgIorAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgIorAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseXorAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgXorAssignOp($0)")
,let('SgNode*', $1, "isSgXorAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgXorAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgXorAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(commaOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgCommaOpExp($0)")
,let('SgNode*', $1, "isSgCommaOpExp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgCommaOpExp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgCommaOpExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(divideAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgDivAssignOp($0)")
,let('SgNode*', $1, "isSgDivAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgDivAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDivAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(divideOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgDivideOp($0)")
,let('SgNode*', $1, "isSgDivideOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgDivideOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDivideOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(dotOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgDotExp($0)")
,let('SgNode*', $1, "isSgDotExp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgDotExp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDotExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(dotStarOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgDotStarOp($0)")
,let('SgNode*', $1, "isSgDotStarOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgDotStarOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDotStarOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(equalOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgEqualityOp($0)")
,let('SgNode*', $1, "isSgEqualityOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgEqualityOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgEqualityOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(greaterThanOrEqualOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgGreaterOrEqualOp($0)")
,let('SgNode*', $1, "isSgGreaterOrEqualOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgGreaterOrEqualOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgGreaterOrEqualOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(greaterThanOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgGreaterThanOp($0)")
,let('SgNode*', $1, "isSgGreaterThanOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgGreaterThanOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgGreaterThanOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(lessThanOrEqualOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgLessOrEqualOp($0)")
,let('SgNode*', $1, "isSgLessOrEqualOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgLessOrEqualOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgLessOrEqualOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(lessThanOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgLessThanOp($0)")
,let('SgNode*', $1, "isSgLessThanOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgLessThanOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgLessThanOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(leftShiftOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgLshiftOp($0)")
,let('SgNode*', $1, "isSgLshiftOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgLshiftOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgLshiftOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(rightShiftOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgRshiftOp($0)")
,let('SgNode*', $1, "isSgRshiftOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgRshiftOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgRshiftOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(leftShiftAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgLshiftAssignOp($0)")
,let('SgNode*', $1, "isSgLshiftAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgLshiftAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgLshiftAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(rightShiftAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgRshiftAssignOp($0)")
,let('SgNode*', $1, "isSgRshiftAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgRshiftAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgRshiftAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(subtractOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgSubtractOp($0)")
,let('SgNode*', $1, "isSgSubtractOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgSubtractOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgSubtractOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(subtractAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgMinusAssignOp($0)")
,let('SgNode*', $1, "isSgMinusAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgMinusAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgMinusAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(modulusOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgModOp($0)")
,let('SgNode*', $1, "isSgModOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgModOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgModOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(modulusAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgModAssignOp($0)")
,let('SgNode*', $1, "isSgModAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgModAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgModAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(multiplyOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgMultiplyOp($0)")
,let('SgNode*', $1, "isSgMultiplyOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgMultiplyOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgMultiplyOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(multiplyAssignOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgMultAssignOp($0)")
,let('SgNode*', $1, "isSgMultAssignOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgMultAssignOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgMultAssignOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(notEqualOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgNotEqualOp($0)")
,let('SgNode*', $1, "isSgNotEqualOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgNotEqualOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgNotEqualOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(logicalOrOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgOrOp($0)")
,let('SgNode*', $1, "isSgOrOp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgOrOp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgOrOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(arrayIndexOperator, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgPntrArrRefExp($0)")
,let('SgNode*', $1, "isSgPntrArrRefExp($0)->get_lhs_operand()")
,let('SgNode*', $2, "isSgPntrArrRefExp($0)->get_rhs_operand()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgPntrArrRefExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionCall, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgFunctionCallExp($0)")
,let('SgNode*', $1, "isSgFunctionCallExp($0)->get_function()")
,let('SgNode*', $2, "isSgFunctionCallExp($0)->get_args()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionCallExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unaryOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgUnaryOp($0)")
,let('SgNode*', $1, "isSgUnaryOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgUnaryOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(addressOfOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgAddressOfOp($0)")
,let('SgNode*', $1, "isSgAddressOfOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgAddressOfOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(bitwiseNotOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgBitComplementOp($0)")
,let('SgNode*', $1, "isSgBitComplementOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgBitComplementOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(castOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgCastExp($0)")
,let('SgNode*', $1, "isSgCastExp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgCastExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(incrementOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgPlusPlusOp($0)")
,let('SgNode*', $1, "isSgPlusPlusOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgPlusPlusOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(decrementOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgMinusMinusOp($0)")
,let('SgNode*', $1, "isSgMinusMinusOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgMinusMinusOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(negateOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgMinusOp($0)")
,let('SgNode*', $1, "isSgMinusOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgMinusOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unaryPlusOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgUnaryAddOp($0)")
,let('SgNode*', $1, "isSgUnaryAddOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgUnaryAddOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(logicalNotOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgNotOp($0)")
,let('SgNode*', $1, "isSgNotOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgNotOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(dereferenceOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgPointerDerefExp($0)")
,let('SgNode*', $1, "isSgPointerDerefExp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgPointerDerefExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(throwOperator, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgThrowOp($0)")
,let('SgNode*', $1, "isSgThrowOp($0)->get_operand()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgThrowOp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(conditionalOperator, 4,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgConditionalExp($0)")
,let('SgNode*', $1, "isSgConditionalExp($0)->get_conditional()")
,let('SgNode*', $2, "isSgConditionalExp($0)->get_true_exp()")
,let('SgNode*', $3, "isSgConditionalExp($0)->get_false_exp()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$3"), let('SgNode*', $0, "$3->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgConditionalExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(deleteExpression, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgDeleteExp($0)")
,let('SgNode*', $1, "isSgDeleteExp($0)->get_variable()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDeleteExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(expressionList, 2,
[rule([+('SgNode*'), -('int')], [cond("isSgExprListExp($0)")
,let('int', $1, "isSgExprListExp($0)->get_expressions().size()")
])
,rule([-('SgNode*'), -('int')], [iterMemoryPools($0, ['SgExprListExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(expressionListElement, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgExprListExp($0) && $1 >= 0 && $1 < isSgExprListExp($0)->get_expressions().size()"), let('SgExpressionPtrList::const_iterator', $100, "isSgExprListExp($0)->get_expressions().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgExprListExp($0)"), iterRange($1, 0, "isSgExprListExp($0)->get_expressions().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgExprListExp']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(classReference, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgClassNameRefExp($0)")
,let('SgNode*', $1, "isSgClassNameRefExp($0)->get_symbol()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgClassNameRefExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionReference, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgFunctionRefExp($0)")
,let('SgNode*', $1, "isSgFunctionRefExp($0)->get_symbol()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionRefExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(memberFunctionReference, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgMemberFunctionRefExp($0)")
,let('SgNode*', $1, "isSgMemberFunctionRefExp($0)->get_symbol()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgMemberFunctionRefExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(variableReference, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgVarRefExp($0)")
,let('SgNode*', $1, "isSgVarRefExp($0)->get_symbol()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgVarRefExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(valueExpression, 1,
[rule([+('SgNode*')], [cond("isSgValueExp($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgValueExp']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(symbol, 1,
[rule([+('SgNode*')], [cond("isSgSymbol($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgSymbol']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(variableSymbol, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgVariableSymbol($0)")
,let('SgNode*', $1, "isSgVariableSymbol($0)->get_declaration()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgVariableSymbol']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(statement, 1,
[rule([+('SgNode*')], [cond("isSgStatement($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(breakStatement, 1,
[rule([+('SgNode*')], [cond("isSgBreakStmt($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgBreakStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(continueStatement, 1,
[rule([+('SgNode*')], [cond("isSgContinueStmt($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgContinueStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(caseStatement, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgCaseOptionStmt($0)")
,let('SgNode*', $1, "isSgCaseOptionStmt($0)->get_condition()")
,let('SgNode*', $2, "isSgCaseOptionStmt($0)->get_body()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgCaseOptionStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(defaultStatement, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgDefaultOptionStmt($0)")
,let('SgNode*', $1, "isSgDefaultOptionStmt($0)->get_body()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDefaultOptionStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(expressionStatement, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgExprStatement($0)")
,let('SgNode*', $1, "isSgExprStatement($0)->get_expression()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgExprStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(gotoStatement, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgGotoStatement($0)")
,let('SgNode*', $1, "isSgGotoStatement($0)->get_label()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgGotoStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(labelStatement, 2,
[rule([+('SgNode*'), -('std::string')], [cond("isSgLabelStatement($0)")
,let('std::string', $1, "isSgLabelStatement($0)->get_label()")
])
,rule([-('SgNode*'), -('std::string')], [iterMemoryPools($0, ['SgLabelStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(returnStatement, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgReturnStmt($0)")
,let('SgNode*', $1, "isSgReturnStmt($0)->get_return_expr()")
])
,rule([-('SgNode*'), +('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgReturnStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(scopeStatement, 1,
[rule([+('SgNode*')], [cond("isSgScopeStatement($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgScopeStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(basicBlock, 2,
[rule([+('SgNode*'), -('int')], [cond("isSgBasicBlock($0)")
,let('int', $1, "isSgBasicBlock($0)->get_statements().size()")
])
,rule([-('SgNode*'), -('int')], [iterMemoryPools($0, ['SgBasicBlock']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(basicBlockElement, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgBasicBlock($0) && $1 >= 0 && $1 < isSgBasicBlock($0)->get_statements().size()"), let('SgStatementPtrList::const_iterator', $100, "isSgBasicBlock($0)->get_statements().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgBasicBlock($0)"), iterRange($1, 0, "isSgBasicBlock($0)->get_statements().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgBasicBlock']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(ifStatement, 4,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgIfStmt($0)")
,let('SgNode*', $1, "isSgIfStmt($0)->get_conditional()")
,let('SgNode*', $2, "isSgIfStmt($0)->get_true_body()")
,let('SgNode*', $3, "isSgIfStmt($0)->get_false_body()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$3"), let('SgNode*', $0, "$3->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgIfStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(switchStatement, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgSwitchStatement($0)")
,let('SgNode*', $1, "isSgSwitchStatement($0)->get_selector()")
,let('SgNode*', $2, "isSgSwitchStatement($0)->get_body()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgSwitchStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(doWhileStatement, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgDoWhileStmt($0)")
,let('SgNode*', $1, "isSgDoWhileStmt($0)->get_condition()")
,let('SgNode*', $2, "isSgDoWhileStmt($0)->get_body()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgDoWhileStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(forStatement, 5,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgForStatement($0)")
,let('SgNode*', $1, "isSgForStatement($0)->get_for_init_stmt()")
,let('SgNode*', $2, "isSgForStatement($0)->get_test()")
,let('SgNode*', $3, "isSgForStatement($0)->get_increment_expr()")
,let('SgNode*', $4, "isSgForStatement($0)->get_loop_body()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$3"), let('SgNode*', $0, "$3->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$4"), let('SgNode*', $0, "$4->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgForStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(globalScope, 2,
[rule([+('SgNode*'), -('int')], [cond("isSgGlobal($0)")
,let('int', $1, "isSgGlobal($0)->get_declarations().size()")
])
,rule([-('SgNode*'), -('int')], [iterMemoryPools($0, ['SgGlobal']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(globalScopeMember, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgGlobal($0) && $1 >= 0 && $1 < isSgGlobal($0)->get_declarations().size()"), let('SgDeclarationStatementPtrList::const_iterator', $100, "isSgGlobal($0)->get_declarations().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgGlobal($0)"), iterRange($1, 0, "isSgGlobal($0)->get_declarations().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgGlobal']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(namespaceDefinition, 3,
[rule([+('SgNode*'), -('SgNode*'), -('int')], [cond("isSgNamespaceDefinitionStatement($0)")
,let('SgNode*', $1, "isSgNamespaceDefinitionStatement($0)->get_namespaceDeclaration()")
,let('int', $2, "isSgNamespaceDefinitionStatement($0)->get_declarations().size()")
])
,rule([-('SgNode*'), +('SgNode*'), -('int')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('int')], [iterMemoryPools($0, ['SgNamespaceDefinitionStatement']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(namespaceDefinitionMember, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgNamespaceDefinitionStatement($0) && $1 >= 0 && $1 < isSgNamespaceDefinitionStatement($0)->get_declarations().size()"), let('SgDeclarationStatementPtrList::const_iterator', $100, "isSgNamespaceDefinitionStatement($0)->get_declarations().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgNamespaceDefinitionStatement($0)"), iterRange($1, 0, "isSgNamespaceDefinitionStatement($0)->get_declarations().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgNamespaceDefinitionStatement']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(whileStatement, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgWhileStmt($0)")
,let('SgNode*', $1, "isSgWhileStmt($0)->get_condition()")
,let('SgNode*', $2, "isSgWhileStmt($0)->get_body()")
])
,rule([-('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$1"), let('SgNode*', $0, "$1->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgWhileStmt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionDefinition, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgFunctionDefinition($0)")
,let('SgNode*', $1, "isSgFunctionDefinition($0)->get_declaration()")
,let('SgNode*', $2, "isSgFunctionDefinition($0)->get_body()")
])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionDefinition']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(classDefinition, 4,
[rule([+('SgNode*'), -('SgNode*'), -('int'), -('int')], [cond("isSgClassDefinition($0)")
,let('SgNode*', $1, "isSgClassDefinition($0)->get_declaration()")
,let('int', $2, "isSgClassDefinition($0)->get_members().size()")
,let('int', $3, "isSgClassDefinition($0)->get_inheritances().size()")
])
,rule([-('SgNode*'), -('SgNode*'), -('int'), -('int')], [iterMemoryPools($0, ['SgClassDefinition']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(classDefinitionMember, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgClassDefinition($0) && $1 >= 0 && $1 < isSgClassDefinition($0)->get_members().size()"), let('SgDeclarationStatementPtrList::const_iterator', $100, "isSgClassDefinition($0)->get_members().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgClassDefinition($0)"), iterRange($1, 0, "isSgClassDefinition($0)->get_members().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgClassDefinition']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(classDefinitionBaseClass, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgClassDefinition($0) && $1 >= 0 && $1 < isSgClassDefinition($0)->get_inheritances().size()"), let('SgBaseClassPtrList::const_iterator', $100, "isSgClassDefinition($0)->get_inheritances().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgClassDefinition($0)"), iterRange($1, 0, "isSgClassDefinition($0)->get_inheritances().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgClassDefinition']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(variableDeclaration, 2,
[rule([+('SgNode*'), -('int')], [cond("isSgVariableDeclaration($0)")
,let('int', $1, "isSgVariableDeclaration($0)->get_variables().size()")
])
,rule([-('SgNode*'), -('int')], [iterMemoryPools($0, ['SgVariableDeclaration']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(variableDeclarationElement, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgVariableDeclaration($0) && $1 >= 0 && $1 < isSgVariableDeclaration($0)->get_variables().size()"), let('SgInitializedNamePtrList::const_iterator', $100, "isSgVariableDeclaration($0)->get_variables().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgVariableDeclaration($0)"), iterRange($1, 0, "isSgVariableDeclaration($0)->get_variables().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgVariableDeclaration']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(initializedName, 4,
[rule([+('SgNode*'), -('std::string'), -('SgNode*'), -('SgNode*')], [cond("isSgInitializedName($0)")
,let('std::string', $1, "isSgInitializedName($0)->get_name()")
,let('SgNode*', $2, "isSgInitializedName($0)->get_type()")
,let('SgNode*', $3, "isSgInitializedName($0)->get_initializer()")
])
,rule([-('SgNode*'), -('std::string'), -('SgNode*'), +('SgNode*')], [cond("$3"), let('SgNode*', $0, "$3->get_parent()"), rescan])
,rule([-('SgNode*'), -('std::string'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgInitializedName']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(classDeclaration, 5,
[rule([+('SgNode*'), -('std::string'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgClassDeclaration($0)")
,let('std::string', $1, "isSgClassDeclaration($0)->get_name()")
,let('SgNode*', $2, "isSgClassDeclaration($0)->get_type()")
,let('SgNode*', $3, "isSgClassDeclaration($0)->get_definition()")
,let('SgNode*', $4, "isSgClassDeclaration($0)->get_scope()")
])
,rule([-('SgNode*'), -('std::string'), -('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$3"), let('SgNode*', $0, "$3->get_parent()"), rescan])
,rule([-('SgNode*'), -('std::string'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgClassDeclaration']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionDeclaration, 5,
[rule([+('SgNode*'), -('std::string'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgFunctionDeclaration($0)")
,let('std::string', $1, "isSgFunctionDeclaration($0)->get_name()")
,let('SgNode*', $2, "isSgFunctionDeclaration($0)->get_parameterList()")
,let('SgNode*', $3, "isSgFunctionDeclaration($0)->get_definition()")
,let('SgNode*', $4, "isSgFunctionDeclaration($0)->get_scope()")
])
,rule([-('SgNode*'), -('std::string'), +('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('std::string'), -('SgNode*'), +('SgNode*'), -('SgNode*')], [cond("$3"), let('SgNode*', $0, "$3->get_parent()"), rescan])
,rule([-('SgNode*'), -('std::string'), -('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionDeclaration']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionParameterList, 2,
[rule([+('SgNode*'), -('int')], [cond("isSgFunctionParameterList($0)")
,let('int', $1, "isSgFunctionParameterList($0)->get_args().size()")
])
,rule([-('SgNode*'), -('int')], [iterMemoryPools($0, ['SgFunctionParameterList']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionParameterListElement, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgFunctionParameterList($0) && $1 >= 0 && $1 < isSgFunctionParameterList($0)->get_args().size()"), let('SgInitializedNamePtrList::const_iterator', $100, "isSgFunctionParameterList($0)->get_args().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgFunctionParameterList($0)"), iterRange($1, 0, "isSgFunctionParameterList($0)->get_args().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionParameterList']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(declarationStatement, 1,
[rule([+('SgNode*')], [cond("isSgDeclaration($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgDeclaration']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(type, 1,
[rule([+('SgNode*')], [cond("isSgType($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(pointerType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgPointerType($0)")
,let('SgNode*', $1, "isSgPointerType($0)->get_base_type()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgPointerType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(arrayType, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgArrayType($0)")
,let('SgNode*', $1, "isSgArrayType($0)->get_base_type()")
,let('SgNode*', $2, "isSgArrayType($0)->get_index()")
])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgArrayType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionType, 3,
[rule([+('SgNode*'), -('SgNode*'), -('SgNode*')], [cond("isSgFunctionType($0)")
,let('SgNode*', $1, "isSgFunctionType($0)->get_return_type()")
,let('SgNode*', $2, "isSgFunctionType($0)->get_argument_list()")
])
,rule([-('SgNode*'), -('SgNode*'), +('SgNode*')], [cond("$2"), let('SgNode*', $0, "$2->get_parent()"), rescan])
,rule([-('SgNode*'), -('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionParameterTypeList, 2,
[rule([+('SgNode*'), -('int')], [cond("isSgFunctionParameterTypeList($0)")
,let('int', $1, "isSgFunctionParameterTypeList($0)->get_arguments().size()")
])
,rule([-('SgNode*'), -('int')], [iterMemoryPools($0, ['SgFunctionParameterTypeList']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(functionParameterTypeListElement, 3,
        [rule([+('SgNode*'), +('int'), -('SgNode*')], [cond("isSgFunctionParameterTypeList($0) && $1 >= 0 && $1 < isSgFunctionParameterTypeList($0)->get_arguments().size()"), let('SgTypePtrList::const_iterator', $100, "isSgFunctionParameterTypeList($0)->get_arguments().begin()"), do("std::advance($100, $1)"), let('SgNode*', $2, "*($100)")]),
         rule([+('SgNode*'), -('int'), -('SgNode*')], [cond("isSgFunctionParameterTypeList($0)"), iterRange($1, 0, "isSgFunctionParameterTypeList($0)->get_arguments().size()"), makeGround($1, 'int'), rescan]),
         rule([-('SgNode*'), -('int'), -('SgNode*')], [iterMemoryPools($0, ['SgFunctionParameterTypeList']), makeGround($0, 'SgNode*'), rescan])]).
:- prim(modifierType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgModifierType($0)")
,let('SgNode*', $1, "isSgModifierType($0)->get_base_type()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgModifierType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(namedType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgNamedType($0)")
,let('SgNode*', $1, "isSgNamedType($0)->get_declaration()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgNamedType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(classType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgClassType($0)")
,let('SgNode*', $1, "isSgClassType($0)->get_declaration()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgClassType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(enumType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgEnumType($0)")
,let('SgNode*', $1, "isSgEnumType($0)->get_declaration()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgEnumType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(typedefType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgTypedefType($0)")
,let('SgNode*', $1, "isSgTypedefType($0)->get_declaration()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgTypedefType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(referenceType, 2,
[rule([+('SgNode*'), -('SgNode*')], [cond("isSgReferenceType($0)")
,let('SgNode*', $1, "isSgReferenceType($0)->get_base_type()")
])
,rule([-('SgNode*'), -('SgNode*')], [iterMemoryPools($0, ['SgReferenceType']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(boolType, 1,
[rule([+('SgNode*')], [cond("isSgTypeBool($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeBool']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(charType, 1,
[rule([+('SgNode*')], [cond("isSgTypeChar($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeChar']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(doubleType, 1,
[rule([+('SgNode*')], [cond("isSgTypeDouble($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeDouble']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(floatType, 1,
[rule([+('SgNode*')], [cond("isSgTypeFloat($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeFloat']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(intType, 1,
[rule([+('SgNode*')], [cond("isSgTypeInt($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeInt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(longType, 1,
[rule([+('SgNode*')], [cond("isSgTypeLong($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeLong']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(longDoubleType, 1,
[rule([+('SgNode*')], [cond("isSgTypeLongDouble($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeLongDouble']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(longLongType, 1,
[rule([+('SgNode*')], [cond("isSgTypeLongLong($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeLongLong']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(shortType, 1,
[rule([+('SgNode*')], [cond("isSgTypeShort($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeShort']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(signedCharType, 1,
[rule([+('SgNode*')], [cond("isSgTypeSignedChar($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeSignedChar']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(signedIntType, 1,
[rule([+('SgNode*')], [cond("isSgTypeSignedInt($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeSignedInt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(signedLongType, 1,
[rule([+('SgNode*')], [cond("isSgTypeSignedLong($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeSignedLong']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(signedShortType, 1,
[rule([+('SgNode*')], [cond("isSgTypeSignedShort($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeSignedShort']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(stringType, 1,
[rule([+('SgNode*')], [cond("isSgTypeString($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeString']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unsignedCharType, 1,
[rule([+('SgNode*')], [cond("isSgTypeUnsignedChar($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeUnsignedChar']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unsignedIntType, 1,
[rule([+('SgNode*')], [cond("isSgTypeUnsignedInt($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeUnsignedInt']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unsignedLongType, 1,
[rule([+('SgNode*')], [cond("isSgTypeUnsignedLong($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeUnsignedLong']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unsignedLongLongType, 1,
[rule([+('SgNode*')], [cond("isSgTypeUnsignedLongLong($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeUnsignedLongLong']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(unsignedShortType, 1,
[rule([+('SgNode*')], [cond("isSgTypeUnsignedShort($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeUnsignedShort']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(voidType, 1,
[rule([+('SgNode*')], [cond("isSgTypeVoid($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeVoid']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(wcharType, 1,
[rule([+('SgNode*')], [cond("isSgTypeWchar($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgTypeWchar']), makeGround($0, 'SgNode*'), rescan])
]).

:- prim(splitCfgNode, 3,
        [rule([+('VirtualCFG::CFGNode'), -('SgNode*'), -(int)],
	      [let('SgNode*', $1, "$0.getNode()"),
	       let(int, $2, "$0.getIndex()")]),
         rule([-('VirtualCFG::CFGNode'), +('SgNode*'), +(int)],
	      [let('VirtualCFG::CFGNode', $0, "VirtualCFG::CFGNode($1, $2)")])]).
:- prim(cfgNext, 2,
        [rule([+('VirtualCFG::CFGNode'), -('VirtualCFG::CFGNode')],
	      [iterCfgEdges($0, "outEdges", "target", $1),
               makeGround($1, 'VirtualCFG::CFGNode')]),
         rule([-('VirtualCFG::CFGNode'), +('VirtualCFG::CFGNode')],
	      [iterCfgEdges($1, "inEdges", "source", $0),
               makeGround($0, 'VirtualCFG::CFGNode')])]).

:- prim(node, 1,
[rule([+('SgNode*')], [cond("isSgNode($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgNode']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(supportNode, 1,
[rule([+('SgNode*')], [cond("isSgSupport($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgSupport']), makeGround($0, 'SgNode*'), rescan])
]).
:- prim(locatedNode, 1,
[rule([+('SgNode*')], [cond("isSgLocatedNode($0)")
])
,rule([-('SgNode*')], [iterMemoryPools($0, ['SgLocatedNode']), makeGround($0, 'SgNode*'), rescan])
]).

:- prim(parent, 2, % Parent then child
        [rule([-('SgNode*'), +('SgNode*')],
	      [cond("$1"), let('SgNode*', $0, "$1->get_parent()")]),
         rule([+('SgNode*'), '_'('SgNode*')],
              [cond("$0 && !$0->get_traversalSuccessorContainer.empty()")]),
         rule([+('SgNode*'), -('SgNode*')],
	      [cond("$0"), iterateChildren($0, $1), makeGround($1, 'SgNode*')])]).


:- prim(compassParameter, 2, % +ParamName, -Value
        [rule([+('std::string'), -('std::string')],
	      [let('std::string', $1, "inputParameters[$0]")])]).

:- prim(compassError, 3, % +Node, +CheckerName, +Description
        [rule([+('SgNode*'), +('std::string'), +('std::string')],
              [do("output->addOutput(new Palette::CheckerOutput($0, $1, $2))")])]).

