/*! \file
  
  \brief The Implementation of OuterRefOpVisitor

  \authors Michelle Strout, Brian White
  \version $Id: ManagerFIAlias.cpp,v 1.1.2.20 2006/01/18 15:38:41 mstrout Exp $

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#include "OuterRefOpVisitor.hpp"


namespace OA {
  namespace Alias {

OuterRefOpVisitor::OuterRefOpVisitor() 
{
}

OuterRefOpVisitor::~OuterRefOpVisitor() 
{
}

OA_ptr<RefOp> OuterRefOpVisitor::getOuterRefOp() 
{
  return mOuterRefOp;
}

void OuterRefOpVisitor::visitNamedRef(NamedRef& ref) 
{ 
}

void OuterRefOpVisitor::visitUnnamedRef(UnnamedRef& ref) 
{ 
}

void OuterRefOpVisitor::visitUnknownRef(UnknownRef& ref) 
{ 
}

void OuterRefOpVisitor::visitAddressOf(AddressOf& ref) 
{
        // this visitor shouldn't be called on an MRE
        // that has its address taken
        assert(0);
}

void OuterRefOpVisitor::visitDeref(Deref& ref) 
{ 
        assert(ref.getNumDerefs()==1);
        OA_ptr<MemRefExpr> nullmre;
        mOuterRefOp = new Deref(MemRefExpr::USE, nullmre, 1);
}

// default handling of more specific SubSet specificiations
void OuterRefOpVisitor::visitSubSetRef(SubSetRef& ref) 
{ 
        OA_ptr<MemRefExpr> nullmre;
        mOuterRefOp = new SubSetRef(MemRefExpr::USE, nullmre);
}

void OuterRefOpVisitor::visitIdxAccess(IdxAccess& ref) { 
        OA_ptr<MemRefExpr> nullmre;
        OA_ptr<MemRefExpr> childMRE = ref.getMemRefExpr();
        assert(!childMRE.ptrEqual(0));
        mOuterRefOp = new IdxAccess(MemRefExpr::USE,
                                    nullmre, ref.getIdx());

}

void OuterRefOpVisitor::visitFieldAccess(FieldAccess& ref) { 
        OA_ptr<MemRefExpr> nullmre;
        OA_ptr<MemRefExpr> childMRE = ref.getMemRefExpr();
        assert(!childMRE.ptrEqual(0));
        mOuterRefOp = new FieldAccess(MemRefExpr::USE,
                                      nullmre, ref.getFieldName() );
}


  } // end of namespace Alias
} // end of namespace OA
