/*! \file
  
  \brief Implementation of Alias::CSFIAliasTagResults.

  \authors Michelle Strout, Barbara Kreaseck

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#include "CSFIAliasTagResults.hpp"


namespace OA {
  namespace Alias {

static bool debug = false;

CSFIAliasTagResults::CSFIAliasTagResults() {
    OA_DEBUG_CTRL_MACRO("DEBUG_CSFIAliasTagResults:ALL", debug);
}

AliasResultType 
CSFIAliasTagResults::alias(MemRefHandle ref1, MemRefHandle ref2)
{
    AliasResultType retval = MAYALIAS;
    // FIXME: NOT implemented yet.
    // If AliasTagSet for ref1 has a non-empty intersection with
    // the AliasTagSet for ref2 then they alias.
    // If either of their sets are may, then the alias is a may alias. 
    //
    // FIXME2: When implemented, will probably want to change this 
    //         interface to include CallContexts 
    
    return retval;
}
       
OA_ptr<AliasTagSet> 
CSFIAliasTagResults::getAliasTags( OA_ptr<MemRefExpr> mre )
{ 
    // no interpretation/implementation of a result with no specific context, yet
    // could keep a parallel structure that coalesces context results ... later
    // -- cannot just use null CallContext, as that is a legitimate CallContext
    //    for root proc
    // just asserting for now.

    assert("queried CSFIAliasTagResult(mre) with no given context -- not implemented\n"
	 && false);
    
    OA_ptr<AliasTagSet> retval;
    retval = new AliasTagSet(false);
    return retval;
}

OA_ptr<AliasTagSet> 
CSFIAliasTagResults::getAliasTags( OA_ptr<MemRefExpr> mre, 
                                   OA_ptr<CallContext> context)
{
    OA_ptr<AliasTagSet> tagSet, retval;

    // wrap mre and context
    MREwContext mrewc(mre,context);

    if (debug) {
      std::cout << "CSFIAliasTagResults::getAliasTags() called, first try:\n";
    }

    std::map<MREwContext, OA_ptr<AliasTagSet> >::iterator mapIter;
    mapIter = mMREwCToTags.find(mrewc);

    // look up the alias tag set for the mre in a map
    if (mapIter != mMREwCToTags.end()) {
      // then use found alias tag set 
      tagSet = mapIter->second;
    } else {
      // possible that mre does not have a context.
      OA_ptr<CallContext> emptyContext; emptyContext = new CallContext();
      MREwContext mrewc(mre,emptyContext);
      if (debug) {
        std::cout << "CSFIAliasTagResults::getAliasTags() called, second try:\n";
      }
      mapIter = mMREwCToTags.find(mrewc);
      if (mapIter != mMREwCToTags.end()) {
        // then use found alias tag set 
        tagSet = mapIter->second;
      } else {
        if (debug) {
          std::cout << "CSFIAliasTagResults::getAliasTags() called, third try:\n";
        }
        retval = new AliasTagSet(false);
	assert("queried CSFIAliasTagResult with unknown context for MemRefExpr\n" && false);
      }
    }

    retval = tagSet->clone();
   
    return retval;
}

OA_ptr<AliasTagSet> 
CSFIAliasTagResults::getAliasTags( MemRefHandle memref )
{
    // no interpretation/implementation of a result with no specific context, yet
    // could keep a parallel structure that coalesces context results ... later
    // -- cannot just use null CallContext, as that is a legitimate CallContext
    //    for root proc
    // just asserting for now.

    assert("queried CSFIAliasTagResult(memref) with no given context -- not implemented\n"
	 && false);
    
    OA_ptr<AliasTagSet> retval;
    retval = new AliasTagSet(false);
    return retval;
}


OA_ptr<AliasTagSet> 
CSFIAliasTagResults::getAliasTags( MemRefHandle memref,
                                   OA_ptr<CallContext> context)
{
    OA_ptr<AliasTagSet> tagSet, retval;

    // wrap memref and context
    MRHwContext mrhwc(memref,context);

    // look up the alias tag set for the mrhwc in a map
    
    std::map<MRHwContext, OA_ptr<AliasTagSet> >::iterator mapIter;
    mapIter = mMemRefwCToTags.find(mrhwc);

    if (mapIter != mMemRefwCToTags.end()) {
      // then use found alias tag set 
      tagSet = mapIter->second;
    } else {
      // possible that this mrh is not assoc. with a context
      OA_ptr<CallContext> emptyContext; emptyContext = new CallContext();
      MRHwContext mrhwc(memref, emptyContext);
      mapIter = mMemRefwCToTags.find(mrhwc);
      if (mapIter != mMemRefwCToTags.end()) {
        // then use found alias tag set
        tagSet = mapIter->second;
      } else {
        retval = new AliasTagSet(false);
	assert("queried AliasTagResult with unknown context for memref\n" && false);
      }
    }

    retval = tagSet->clone();

    return retval;
}


//! return iterator over CallContexts for this mre
OA_ptr<CallContextSetIterator> 
CSFIAliasTagResults::getCallContextSet(OA_ptr<MemRefExpr> mre)
{
  OA_ptr<CallContextSetIterator> retval;
  OA_ptr<CallContextSet> ccSet;
  if (mMREToCCSet.find(mre) != mMREToCCSet.end()) {
    ccSet = mMREToCCSet[mre];
  } else {
    assert("CSFIAliasTagResults: no CallContextSet found for this mre" 
           && false);
  }
  retval = new CallContextSetIterator(*ccSet);
  return retval;
}


//! Return the maximum value for all of the alias tags this class knows
//! about.  Range of alias tags will be from 0 through this value.
AliasTag 
CSFIAliasTagResults::getMaxAliasTag() 
{
    std::map<AliasTag, OA_ptr<std::set<MRHwContext> > >::iterator iter;
    AliasTag max(0);
    for (iter=mTagToMemRefwCs.begin(); iter != mTagToMemRefwCs.end(); iter++) {
        if (max < iter->first ) {
            max = iter->first;
        }
    }
    return max;
}

//! Given an AliasTag, returns an iterator over MemRefExprs that 
//! may access the given tag.
OA_ptr<MemRefExprIterator> 
CSFIAliasTagResults::getMemRefExprIterator(AliasTag tag) const
{
    OA_ptr<MemRefExprIterator> retval;

    OA_ptr<std::set<OA_ptr<MemRefExpr> > > mreSet;
    mreSet = new std::set<OA_ptr<MemRefExpr> >();

    OA_ptr<std::set<MREwContext> > mrewcSet;
    mrewcSet = mTagToMREwCs.find(tag)->second;

    assert(!mrewcSet.ptrEqual(NULL));

    std::set<MREwContext>::iterator mrewcIter;
    for (mrewcIter = mrewcSet->begin();
	 mrewcIter != mrewcSet->end();
	 mrewcIter++)
      {
	MREwContext mrewc = *mrewcIter;
	OA_ptr<MemRefExpr> mre = mrewc.getMRE();
	if (mreSet->find(mre) == mreSet->end()) {
	  mreSet->insert(mre);
	}
      }

    retval = new MemRefExprIterator(mreSet);

    return retval;
}




//*****************************************************************
// Construction methods 
//*****************************************************************

void 
CSFIAliasTagResults::mapMemRefToAliasTagSet(
        OA_ptr<MemRefExpr> mre, OA_ptr<AliasTagSet> alias_tag_set )
{
    // CSFIAliasTagResults is not currently handling mre/memrefs without specific contexts
    // -- cannot just use Null CallContext as that is a legitimate context for root procs
    // just assert for now.

  assert("requested mapMemRefToAliasTagSet(mre) without specific context -- not implemented\n"
	 && false);

}

//! Associate a MemRefHandle with given alias tag
void 
CSFIAliasTagResults::mapMemRefToAliasTagSet( 
        MemRefHandle ref, OA_ptr<AliasTagSet> alias_tag_set )
{
    // CSFIAliasTagResults is not currently handling mre/memrefs without specific contexts
    // -- cannot just use Null CallContext as that is a legitimate context for root procs
    // just assert for now.

    assert("requested mapMemRefToAliasTagSet(memref) without specific context -- not implemented\n"
	 && false);

    
}

//! Associate an MRE + Context with given alias tag set
void 
CSFIAliasTagResults::mapMemRefToAliasTagSet( OA_ptr<MemRefExpr> mre,
				 OA_ptr<CallContext> context,
				 OA_ptr<AliasTagSet> alias_tag_set)
{
    // wrap mre and context
    MREwContext mrewc(mre,context);

    // map MRE to set of tags
    mMREwCToTags[mrewc] = alias_tag_set;

    // for each tag in the set, map tag to MREwC
    OA_ptr<AliasTagIterator> tagIter = alias_tag_set->getIterator();
    AliasTag alias_tag;
    for ( ; tagIter->isValid(); ++(*tagIter) ) {
        alias_tag = tagIter->current();
        if(mTagToMREwCs[alias_tag].ptrEqual(NULL)) {
	    mTagToMREwCs[alias_tag] = new std::set<MREwContext>();
        }

        mTagToMREwCs[alias_tag]->insert(mrewc);
    }
    // set may/must flag
    mMREwCToMustFlag[mrewc] = alias_tag_set->isMust();

    // -------
    // throw CallContext into set for this MRE
    if (mMREToCCSet[mre].ptrEqual(NULL)) {
      mMREToCCSet[mre] = new CallContextSet();
    }
    if (!context.ptrEqual(0)) {
      mMREToCCSet[mre]->insert(context);
    }

}

//! Associate a MemRefHandle + Context with given alias tag
void 
CSFIAliasTagResults::mapMemRefToAliasTagSet( MemRefHandle ref,
				 OA_ptr<CallContext> context,
				 OA_ptr<AliasTagSet> alias_tag_set)
{
    // wrap ref and context
    MRHwContext mrhwc(ref,context);

    // map memref handle to set of tags
    mMemRefwCToTags[mrhwc] = alias_tag_set;

    // for each tag in the set, map tag to MemRefHandle
    OA_ptr<AliasTagIterator> tagIter = alias_tag_set->getIterator();
    AliasTag alias_tag;
    for ( ; tagIter->isValid(); ++(*tagIter) ) {
        alias_tag = tagIter->current();
        if(mTagToMemRefwCs[alias_tag].ptrEqual(NULL)) {
            mTagToMemRefwCs[alias_tag] = new std::set<MRHwContext >();
        }

        mTagToMemRefwCs[alias_tag]->insert(mrhwc);
    }

    // set may/must flag
    mMemRefwCToMustFlag[mrhwc] = alias_tag_set->isMust();

}



  } // end of Alias namespace
} // end of OA namespace


