function expcoarsen(newfile,oldfile,resolution);
%EXPCOARSEN - coarsen an exp contour
%
%   This routine read an Argus file and remove points with respect to
%   the resolution (in meters) given in input. 
%
%   Usage:
%      expcoarsen(newfile,oldfile,resolution)
%
%   Example:
%       expcoarsen('DomainOutline.exp','Antarctica.exp',4000)

%Some checks
if nargin~=3 | nargout
	error('expcoarsen usage: expcoarsen(newfile,oldfile,resolution)')
elseif ~exist(oldfile)
	error(['expcut error message: the file ' oldfile  'does not exist'])
elseif exist(newfile),
	choice=input(['A file ' newfile ' already exists, do you want to modify it? (y/n)'],'s');
	if ~strcmpi(choice,'y'),
		disp('no modification done ... exiting');
		return;
	end
end

%Get exp oldfile
[path root ext ver]=fileparts(oldfile);
A=expread(oldfile,1);
numprofiles=size(A,2);
A(1).x(end)

%Go through the profiles
for i=1:numprofiles

	%get number of points and initialize j
	numpoints=length(A(i).x);
	j=1;

	%stop if we have reached end of profile (always keep the last point)
	while j<numpoints-1,,

		%See whether we keep this point or not
		if sqrt((A(i).x(j)-A(i).x(j+1))^2+(A(i).y(j)-A(i).y(j+1))^2)<resolution
			A(i).x(j+1)=[];
			A(i).y(j+1)=[];
			numpoints=numpoints-1;
		else
			%update current point
			j=j+1;
		end
	end

end
A(1).x(end)

expwrite(A,newfile);
