#!/bin/sh
#  this shell script will automatically reconfigure the entire ISSM 
#  archive.


 ACLOCAL="$ISSM_TIER/externalpackages/automake/install/bin/aclocal"
AUTOCONF="$ISSM_TIER/externalpackages/autoconf/install/bin/autoconf"
AUTOHEAD="$ISSM_TIER/externalpackages/autoconf/install/bin/autoheader"
AUTOMAKE="$ISSM_TIER/externalpackages/automake/install/bin/automake"

echo "removing config.cach"
rm -rf config.cach
rm -rf aclocal.m4

if [ ! -f "$ACLOCAL" ]
then echo "issm aclocal not found, calling default aclocal" 
	aclocal -I m4
else echo "Calling aclocal" 
	$ACLOCAL -I m4
fi

if [ ! -f "$AUTOCONF" ]
then echo "issm autoconf not found, calling default aclocal" 
	autoconf
else echo "Calling autoconf" 
	$AUTOCONF
fi

if [ ! -f "$AUTOHEAD" ]
then echo "issm autoheader not found, calling default aclocal" 
	autoheader
else echo "Calling autoheader" 
	$AUTOHEAD
fi

if [ ! -f "$AUTOMAKE" ]
then echo "issm automake  not found, calling default aclocal" 
	automake
else echo "Calling automake " 
	$AUTOMAKE -a
fi
