#!/bin/bash

#version of automake
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/automake-//g'`
echo $version

#Some cleanup
rm -rf install automake-$version src

#Create install directories
mkdir install

#Untar 
tar -zxvf  automake-$version.tar.gz

#Move automake into src directory
mv automake-$version src

#Compile automake
cd src 
./configure --prefix="$ISSM_TIER/externalpackages/automake/install" 
make  
make install
