/*!\file KML_Comment.cpp
 * \brief: implementation of the kml_comment object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Comment::KML_Comment(){{{1*/
KML_Comment::KML_Comment(){

	value     =NULL;

}
/*}}}*/
/*FUNCTION KML_Comment::~KML_Comment(){{{1*/
KML_Comment::~KML_Comment(){

	if (value     ) xfree((void**)&value);

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Comment::Echo {{{1*/
void  KML_Comment::Echo(){

	bool  flag=true;

	_printf_(flag,"    ");
	_printf_(flag,"%s\n",value);

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::DeepEcho {{{1*/
void  KML_Comment::DeepEcho(){

	char  indent[81]="";

	KML_Comment::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::DeepEcho {{{1*/
void  KML_Comment::DeepEcho(char* indent){

	bool  flag=true;

	_printf_(flag,"%s    ",indent);
	_printf_(flag,"%s\n",value);

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::Write {{{1*/
void  KML_Comment::Write(FILE* filout,char* indent){

	if (strncmp(&value[0]              ,"<!--",4))
		fprintf(filout,"%s<!--\n",indent);
	fprintf(filout,"%s  %s\n",indent,value);
	if (strncmp(&value[strlen(value)-3],"-->" ,3))
		fprintf(filout,"%s-->\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::Read {{{1*/
void  KML_Comment::Read(FILE* fid,char* kstr){

//  comments always read as part of KMLFileToken

	;

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::Alloc {{{1*/
void  KML_Comment::Alloc(char* valuei){

	value=(char *) xmalloc((strlen(valuei)+1)*sizeof(char));
	memcpy(value,valuei,(strlen(valuei)+1)*sizeof(char));

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::Add {{{1*/
void  KML_Comment::Add(DataSet* commnt){

	commnt->AddObject((Object*)this);

	return;
}
/*}}}*/

/*FUNCTION KML_Comment::Get {{{1*/
void  KML_Comment::Get(char** pvalueo){

	*pvalueo=(char *) xmalloc((strlen(value)+1)*sizeof(char));
	memcpy(*pvalueo,value,(strlen(value)+1)*sizeof(char));

	return;
}
/*}}}*/

