function  options_struct=parse_options(md,optionstring);
%PARSE_OPTIONS - build a structure that holds all plot options
%
%   Usage:
%      options_struct=parse_options(md,optionstring);
%
%   See also: PLOTMODEL

%units
unitvalues=findarg(optionstring,'unit');
if ~isempty(unitvalues),
	if strcmpi(unitvalues.value,'km'),
		options_struct.unitmultiplier=10^-3;
	end
else
	options_struct.unitmultiplier=NaN;
end

%density
densityvalues=findarg(optionstring,'density');
if ~isempty(densityvalues),
	options_struct.density=abs(ceil(densityvalues(1).value));
else
	options_struct.density=NaN;
end

%Section profile
sectionvalues=findarg(optionstring,'sectionvalue');
if ~isempty(sectionvalues),
	if ischar(sectionvalues(1).value),
		options_struct.sectionvalue=sectionvalues(1).value;
	else
		options_struct.sectionvalue=0;
	end
else
	options_struct.sectionvalue=NaN;
end

%Resolution to be used by section profile
resolution=findarg(optionstring,'resolution');
if ~isempty(resolution),
	options_struct.resolution=resolution(1).value;
else
	options_struct.resolution=NaN;
end

%Show section
showsection=findarg(optionstring,'showsection');
if ~isempty(showsection),
	if ischar(showsection(1).value) & strcmpi(showsection(1).value,'on'),
		options_struct.showsection=4;
	else
		options_struct.showsection=showsection(1).value;
	end
else
	options_struct.showsection=NaN;
end

%iceshelf values
iceshelfvalues=findarg(optionstring,'iceshelf');
if ~isempty(iceshelfvalues),
	if strcmpi(iceshelfvalues(1).value,'none'),
		options_struct.noiceshelf=1;
	else
		options_struct.noiceshelf=0;
	end
else
	options_struct.noiceshelf=0;
end

%icesheet values
icesheetvalues=findarg(optionstring,'icesheet');
if ~isempty(icesheetvalues),
	if strcmpi(icesheetvalues(1).value,'none'),
		options_struct.noicesheet=1;
	else
		options_struct.noicesheet=0;
	end
else
	options_struct.noicesheet=0;
end

%Antzoom
antzoomvalues=findarg(optionstring,'antzoom');
if ~isempty(antzoomvalues),
	options_struct.antzoom=antzoomvalues(1).value;
else
	options_struct.antzoom=NaN;
end

%transient_movie
transient_movie_values=findarg(optionstring,'transient_movie');
if ~isempty(transient_movie_values),
	if(ischar(transient_movie_values.value)),
		options_struct.transient_movie=str2num(transient_movie_values.value);
	else
		options_struct.transient_movie=transient_movie_values.value;
	end
else
	options_struct.transient_movie=NaN;
end

%fontsize
fontsize_values=findarg(optionstring,'fontsize');
if ~isempty(fontsize_values),
	if(ischar(fontsize_values.value)),
		options_struct.fontsize=str2num(fontsize_values.value);
	else
		options_struct.fontsize=fontsize_values.value;
	end
else
	options_struct.fontsize=NaN;
end

%fontweight
fontweight_values=findarg(optionstring,'fontweight');
if ~isempty(fontweight_values),
	options_struct.fontweight=fontweight_values.value;
else
	options_struct.fontweight=NaN;
end

%smoothing
smooth_values=findarg(optionstring,'smooth');
if ~isempty(smooth_values),
	if strcmpi(smooth_values.value,'on'),
		options_struct.smooth=1;
	else
		options_struct.smooth=smooth_values.value;
	end
else
	options_struct.smooth=NaN;
end

%streamlines
streamlines_values=findarg(optionstring,'streamlines');
if ~isempty(streamlines_values),
	options_struct.streamlines=streamlines_values.value;
else
	options_struct.streamlines=NaN;
end

%contouronly
contouronly_values=findarg(optionstring,'contouronly');
if ~isempty(contouronly_values) & strcmpi(contouronly_values.value,'on'),
	options_struct.contouronly=1;
else
	options_struct.contouronly=NaN;
end

%contourlevels
contourlevels_values=findarg(optionstring,'contourlevels');
if ~isempty(contourlevels_values),
	options_struct.contourlevels=contourlevels_values.value;
else
	options_struct.contourlevels=NaN;
end

%contour color
contourcolor_values=findarg(optionstring,'contourcolor');
if ~isempty(contourcolor_values),
	options_struct.contourcolor=contourcolor_values.value;
else
	options_struct.contourcolor=NaN;
end

%contour ticks
contourticks_values=findarg(optionstring,'contourticks');
if ~isempty(contourticks_values),
	options_struct.contourticks=contourticks_values.value;
else
	options_struct.contourticks=NaN;
end

%highlight
highlight_values=findarg(optionstring,'highlight');
if ~isempty(highlight_values),
	options_struct.highlight=highlight_values.value;
else
	options_struct.highlight=NaN;
end

%layer projection? 
layer_values=findarg(optionstring,'layer');
if ~isempty(layer_values),
	options_struct.layer=layer_values(1).value;
	if (options_struct.layer<=0 | options_struct.layer>md.numlayers),
		error(['plot error message: layer option should be between 1 and ' num2str(md.numlayers)]);
	else
		%we are projecting onto  2d mesh. 
		if ~strcmpi(md.type,'3d'),
			error('plot error message: layer option only supported for 3d type mesh');
		end
	end
else
	options_struct.layer=NaN;
end

%title
titlevalues=findarg(optionstring,'title');
if ~isempty(titlevalues),
	if ischar(titlevalues.value),
		options_struct.title=titlevalues.value;
	else
		error('plot error message: title option must be a string');
	end
else
	options_struct.title=NaN;
end

%xlabel
xlabelvalues=findarg(optionstring,'xlabel');
if ~isempty(xlabelvalues),
	if ischar(xlabelvalues.value),
		options_struct.xlabel=xlabelvalues.value;
	else
		error('plot error message: xlabel option must be a string');
	end
else
	options_struct.xlabel=NaN;
end

%ylabel
ylabelvalues=findarg(optionstring,'ylabel');
if ~isempty(ylabelvalues),
	if ischar(ylabelvalues.value),
		options_struct.ylabel=ylabelvalues.value;
	else
		error('plot error message: ylabel option must be a string');
	end
else
	options_struct.ylabel=NaN;
end

%zlabel
zlabelvalues=findarg(optionstring,'zlabel');
if ~isempty(zlabelvalues),
	if ischar(zlabelvalues.value),
		options_struct.zlabel=zlabelvalues.value;
	else
		error('plot error message: zlabel option must be a string');
	end
else
	options_struct.zlabel=NaN;
end

%view
viewvalues=findarg(optionstring,'view');
if ~isempty(viewvalues),
	options_struct.view=viewvalues.value;
else
	options_struct.view=NaN;
end

%Caxis
caxisvalues=findarg(optionstring,'caxis');
if ~isempty(caxisvalues),
	options_struct.caxis=caxisvalues.value;
else
	options_struct.caxis=NaN;
end

%xlim
xlimvalues=findarg(optionstring,'xlim');
if ~isempty(xlimvalues),
	options_struct.xlim=xlimvalues.value;
else
	options_struct.xlim=NaN;
end

%ylim
ylimvalues=findarg(optionstring,'ylim');
if ~isempty(ylimvalues),
	options_struct.ylim=ylimvalues.value;
else
	options_struct.ylim=NaN;
end

%zlim
zlimvalues=findarg(optionstring,'zlim');
if ~isempty(zlimvalues),
	options_struct.zlim=zlimvalues.value;
else
	options_struct.zlim=NaN;
end


%shading
shadingvalues=findarg(optionstring,'shading');
if ~isempty(shadingvalues),
	if ischar(shadingvalues.value),
		options_struct.shading=shadingvalues.value;
	else
		error('plot error message: shading option must be a string');
	end
else
	options_struct.shading=NaN;
end

%grid
gridvalues=findarg(optionstring,'grid');
if ~isempty(gridvalues),
	if ischar(gridvalues.value),
		options_struct.grid=gridvalues.value;
	else
		error('plot error message: grid option must be a string');
	end
else
	options_struct.grid=NaN;
end

%Colorbar;
colorbarvalues=findarg(optionstring,'colorbar');
if ~isempty(colorbarvalues),
	if ischar(colorbarvalues.value),
		if strcmpi(colorbarvalues.value,'on'),
			options_struct.colorbar=1;
		elseif strcmpi(colorbarvalues.value,'off'),
			options_struct.colorbar=0;
		end
	else
		error('plot error message: colorbarvalues option must be ''on'' or ''off''');
	end
else
	options_struct.colorbar=NaN;
end

%Colorbar position;
colorbarposvalues=findarg(optionstring,'colorbarpos');
if ~isempty(colorbarposvalues),
	options_struct.colorbarpos=colorbarposvalues.value;
else
	options_struct.colorbarpos=NaN;
end

%Colormap;
colormapvalues=findarg(optionstring,'colormap');
if ~isempty(colormapvalues),
	if ischar(colormapvalues.value),
		options_struct.colormap=colormapvalues.value;
	else
		error('plot error message: colormapvalues option must be a string');
	end
else
	options_struct.colormap=NaN;
end

%Wrapping colormap;
wrappingvalues=findarg(optionstring,'wrapping');
if ~isempty(wrappingvalues),
	options_struct.wrapping=wrappingvalues.value;
else
	options_struct.wrapping=NaN;
end

%axis
axisvalues=findarg(optionstring,'axis');
if ~isempty(axisvalues),
	options_struct.axis=axisvalues.value;
else
	options_struct.axis=NaN;
end

%area
areavalues=findarg(optionstring,'area');
if ~isempty(areavalues),
	if ischar(areavalues.value),
		options_struct.area=areavalues.value;
	else
		error('plot error message: area option must be a string');
	end
else
	options_struct.area=NaN;
end

%edgecolor
edgecolorvalues=findarg(optionstring,'edgecolor');
if ~isempty(edgecolorvalues),
	if ischar(edgecolorvalues.value),
		options_struct.edgecolor=edgecolorvalues.value;
	else
		error('plot error message: edgecolor option must be a string');
	end
else
	options_struct.edgecolor=NaN;
end

%overlay
overlayvalues=findarg(optionstring,'overlay');
if ~isempty(overlayvalues),
	if ischar(overlayvalues.value),
		options_struct.overlay=overlayvalues.value;
	else
		error('plot error message: overlay option must be a string');
	end
else
	options_struct.overlay=NaN;
end

%highres
highresvalues=findarg(optionstring,'highres');
if ~isempty(highresvalues),
	options_struct.highres=highresvalues.value;
else
	options_struct.highres=0;
end

%windowsize
windowsizevalues=findarg(optionstring,'windowsize');
if ~isempty(windowsizevalues),
	if isscalar(windowsizevalues.value),
		options_struct.windowsize=windowsizevalues.value;
	else
		error('plot error message: windowsize option must be a string');
	end
else
	options_struct.windowsize=1;
end

%alpha
alphavalues=findarg(optionstring,'alpha');
if ~isempty(alphavalues),
	if isscalar(alphavalues.value),
		options_struct.alpha=alphavalues.value;
	else
		error('plot error message: alpha option must be a string');
	end
else
	options_struct.alpha=1.5; %Rignot setting.
end
	
%text
%1: textsize
textsizevalues=findarg(optionstring,'textsize');
textsizevaluesarray=cell(0,0);
if ~isempty(textsizevalues)
	textsizevalues=textsizevalues.value;
	%ischar if only one textsize -> create a cell
	if ischar(textsizevalues),
		textsizevalues={textsizevalues};
	end
else
	textsizevalues={14};
end
%2: textweight
textweightvalues=findarg(optionstring,'textweight');
textweightvaluesarray=cell(0,0);
if ~isempty(textweightvalues)
	textweightvalues=textweightvalues.value;
	%ischar if only one textweight -> create a cell
	if ischar(textweightvalues),
		textweightvalues={textweightvalues};
	end
else
	textweightvalues={'n'};
end
%3: textcolor
textcolorvalues=findarg(optionstring,'textcolor');
textcolorvaluesarray=cell(0,0);
if ~isempty(textcolorvalues)
	textcolorvalues=textcolorvalues.value;
	%ischar if only one textcolor -> create a cell
	if ischar(textcolorvalues),
		textcolorvalues={textcolorvalues};
	end
else
	textcolorvalues={'k'};
end
%4: textposition
textpositionvalues=findarg(optionstring,'textposition');
textpositionvaluesarray=cell(0,0);
if ~isempty(textpositionvalues)
	textpositionvalues=textpositionvalues.value;
	%isnumeric if only one textposition -> create a cell
	if isnumeric(textpositionvalues),
		textpositionvalues={textpositionvalues};
	end
end
%5: textvalue
textvalues=findarg(optionstring,'text');
textvaluesarray=cell(0,0);
if ~isempty(textvalues),
	textvalues=textvalues.value;
	%ischar if only one expstyle -> create a cell
	if ischar(textvalues),
		textvalues={textvalues};
	end
	%get options
	for i=1:length(textvalues)
		textvaluesarray{end+1}=textvalues{i};
		%size
		if (length(textsizevalues)>=i),
			textsizevaluesarray{end+1}=textsizevalues{i};
		else
			textsizevaluesarray{end+1}=textsizevalues{1};
		end
		%weight
		if (length(textweightvalues)>=i),
			textweightvaluesarray{end+1}=textweightvalues{i};
		else
			textweightvaluesarray{end+1}=textweightvalues{1};
		end
		%color
		if (length(textcolorvalues)>=i),
			textcolorvaluesarray{end+1}=textcolorvalues{i};
		else
			textcolorvaluesarray{end+1}=textcolorvalues{1};
		end
		%position
		if (length(textpositionvalues)>=i),
			textpositionvaluesarray{end+1}=textpositionvalues{i};
		else
			error('plotmodel error message: one or more textposition is missing');
		end
	end
end
options_struct.text=textvaluesarray;
options_struct.textsize=textsizevaluesarray;
options_struct.textweight=textweightvaluesarray;
options_struct.textcolor=textcolorvaluesarray;
options_struct.textposition=textpositionvaluesarray;

%expdisp
expdispvalues=findarg(optionstring,'expdisp');
expdispvaluesarray=cell(0,0);
expstylevalues=findarg(optionstring,'expstyle');
expstylevaluesarray=cell(0,0);
if ~isempty(expstylevalues)
	expstylevalues=expstylevalues.value;
	%ischar if only one expstyle -> create a cell
	if ischar(expstylevalues),
		expstylevalues={expstylevalues};
	end
end
if ~isempty(expdispvalues),
	expdispvalues=expdispvalues.value;
	%ischar if only one expstyle -> create a cell
	if ischar(expdispvalues),
		expdispvalues={expdispvalues};
	end
	for i=1:length(expdispvalues)
		expdispvaluesarray{end+1}=expdispvalues{i};
		if (length(expstylevalues)>=i),
			expstylevaluesarray{end+1}=expstylevalues{i};
		else
			expstylevaluesarray{end+1}='g-';
		end
	end
end
options_struct.expdisp=expdispvaluesarray;
options_struct.expstyle=expstylevaluesarray;

%latlon
latlonvalues=findarg(optionstring,'latlon');
if ~isempty(latlonvalues),
	options_struct.latlon=latlonvalues.value;
else
	options_struct.latlon=NaN;
end

%latlonnumbering
latlonnumberingvalues=findarg(optionstring,'latlonnumbering');
if ~isempty(latlonnumberingvalues),
	options_struct.latlonnumbering=latlonnumberingvalues.value;
else
	options_struct.latlonnumbering=NaN;
end

%latlonnumbering
latlonclickvalues=findarg(optionstring,'latlonclick');
if ~isempty(latlonclickvalues),
	if  strcmpi(latlonclickvalues.value,'on'),
		options_struct.latlonclick=1;
	else
		options_struct.latlonclick=NaN;
	end
else
	options_struct.latlonclick=NaN;
end

%north arrow
northarrowvalues=findarg(optionstring,'northarrow');
if ~isempty(northarrowvalues),
	if  strcmpi(northarrowvalues.value,'on')
		%default values
		Lx=max(md.y)-min(md.y);
		Ly=max(md.y)-min(md.y);
		%default values
		northarrowvalues.value=[min(md.x)+1/6*Lx   min(md.y)+5/6*Ly   1/15*Ly   0.25   1/250*Ly];
	end
	options_struct.northarrow=northarrowvalues.value;
else
	options_struct.northarrow=NaN;
end

%scale ruler
scalerulervalues=findarg(optionstring,'scaleruler');
if ~isempty(scalerulervalues),
	if  strcmpi(scalerulervalues.value,'on')
		%default values
		Lx=max(md.y)-min(md.y);
		Ly=max(md.y)-min(md.y);
		%default values
		scalerulervalues.value=[min(md.x)+6/8*Lx   min(md.y)+1/10*Ly   10^(ceil(log10(Lx)))/5 floor(Lx/100) 5];
	end
	options_struct.scaleruler=scalerulervalues.value;
else
	options_struct.scaleruler=NaN;
end


%designvariable
designvariable=findarg(optionstring,'designvariable');
if ~isempty(designvariable),
	if ischar(designvariable(1).value),
		options_struct.designvariable=designvariable(1).value;
	else
		options_struct.designvariable=0;
	end
else
	options_struct.designvariable=NaN;
end

%responsefunction
responsefunction=findarg(optionstring,'responsefunction');
if ~isempty(responsefunction),
	if ischar(responsefunction(1).value),
		options_struct.responsefunction=responsefunction(1).value;
	else
		options_struct.responsefunction=0;
	end
else
	options_struct.responsefunction=NaN;
end


%log
logvalues=findarg(optionstring,'log');
if ~isempty(logvalues),
	options_struct.log=logvalues(1).value;
else
	options_struct.log=NaN;
end

%border
bordervalues=findarg(optionstring,'border');
if ~isempty(bordervalues),
	options_struct.border=bordervalues(1).value;
else
	options_struct.border=0;
end
