/*
class Particle added by Milan Jirasek on 1 Feb 2010

                   *****    *****   ******  ******  ***   ***                            
                 **   **  **   **  **      **      ** *** **                             
                **   **  **   **  ****    ****    **  *  **                              
               **   **  **   **  **      **      **     **                               
              **   **  **   **  **      **      **     **                                
              *****    *****   **      ******  **     **         
            
                                                                   
               OOFEM : Object Oriented Finite Element Code                 
                    
                 Copyright (C) 1993 - 2010   Borek Patzak                                       



         Czech Technical University, Faculty of Civil Engineering,
     Department of Structural Mechanics, 166 29 Prague, Czech Republic
                                                                               
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                                                                              
*/


#include "particle.h"


namespace oofem {

/**
   Constructor. Creates a particle with number n, belonging to aDomain.
*/
Particle :: Particle (int n, Domain* aDomain) : Node (n, aDomain)
{
}

/**
   Gets all the data of the receiver from the source line of the data file.
*/
IRResultType
Particle :: initializeFrom (InputRecord* ir)
{
  const char *__proc = "initializeFrom"; 
  IRResultType result;                   
  
  Node::initializeFrom (ir);
    
  IR_GIVE_FIELD (ir, radius, IFT_Particle_rad, "rad"); 
  if (radius<0.0)
   _error ("particle: negative radius");

  return IRRT_OK;
}

} // namespace oofem
