/* \file objects.h
 * \brief: prototype header for all objects.
 */

#ifndef ALL_OBJECTS_H_
#define ALL_OBJECTS_H_

/*Abstract classes: */
#include "./Object.h"

/*Objects: */
#include "./Hook.h"
#include "./DofIndexing.h"
#include "./Vertex.h"
#include "./Node.h"
#include "./Segment.h"
#include "./IoModel.h"
#include "./Patch.h"
#include "./Update.h"

/*Constraints: */
#include "./Constraints/Constraint.h"
#include "./Constraints/SpcStatic.h"
#include "./Constraints/SpcTransient.h"
#include "./Constraints/SpcDynamic.h"

/*Gauss*/
#include "./Gauss/GaussTria.h"
#include "./Gauss/GaussPenta.h"

/*Loads: */
#include "./Loads/Friction.h"
#include "./Loads/Icefront.h"
#include "./Loads/Numericalflux.h"
#include "./Loads/Riftfront.h"
#include "./Loads/Penpair.h"
#include "./Loads/Pengrid.h"

/*Elements: */
#include "./Elements/Element.h"
#include "./Elements/Penta.h"
#include "./Elements/PentaHook.h"
#include "./Elements/PentaRef.h"
#include "./Elements/Tria.h"
#include "./Elements/TriaHook.h"
#include "./Elements/TriaRef.h"

/*KML parsing objects: */
#include "./KML/KML_Attribute.h"
#include "./KML/KML_ColorStyle.h"
#include "./KML/KML_Container.h"
#include "./KML/KML_Document.h"
#include "./KML/KML_Feature.h"
#include "./KML/KML_File.h"
#include "./KML/KML_Folder.h"
#include "./KML/KML_Geometry.h"
#include "./KML/KML_GroundOverlay.h"
#include "./KML/KML_Icon.h"
#include "./KML/KML_LatLonBox.h"
#include "./KML/KML_LinearRing.h"
#include "./KML/KML_LineString.h"
#include "./KML/KML_LineStyle.h"
#include "./KML/KML_MultiGeometry.h"
#include "./KML/KML_Object.h"
#include "./KML/KML_Overlay.h"
#include "./KML/KML_Point.h"
#include "./KML/KML_Placemark.h"
#include "./KML/KML_Polygon.h"
#include "./KML/KML_PolyStyle.h"
#include "./KML/KML_Style.h"
#include "./KML/KML_StyleSelector.h"
#include "./KML/KML_SubStyle.h"
#include "./KML/KMLFileReadUtils.h"

/*Option parsing objects: */
#include "./Options/Option.h"
#include "./Options/OptionDouble.h"
#include "./Options/OptionLogical.h"
#include "./Options/OptionChar.h"
#include "./Options/OptionStruct.h"
#include "./Options/OptionCell.h"
#include "./Options/OptionUtilities.h"

/*Inputs: */
#include "./Inputs/Input.h"
#include "./Inputs/BoolInput.h"
#include "./Inputs/DoubleInput.h"
#include "./Inputs/IntInput.h"
#include "./Inputs/PentaVertexInput.h"
#include "./Inputs/TriaVertexInput.h"
#include "./Inputs/ControlInput.h"
#include "./Inputs/DatasetInput.h"
#include "./Inputs/TransientInput.h"

/*ElementResults: */
#include "./ElementResults/ElementResult.h"
#include "./ElementResults/DoubleElementResult.h"
#include "./ElementResults/TriaVertexElementResult.h"
#include "./ElementResults/PentaVertexElementResult.h" 
#include "./ElementResults/BoolElementResult.h"

/*ExternalResults: */
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/BoolExternalResult.h"
#include "./ExternalResults/DoubleExternalResult.h"
#include "./ExternalResults/DoubleVecExternalResult.h"
#include "./ExternalResults/DoubleMatExternalResult.h"
#include "./ExternalResults/IntExternalResult.h"
#include "./ExternalResults/PetscVecExternalResult.h"
#include "./ExternalResults/StringExternalResult.h"

/*Materials: */
#include "./Materials/Material.h"
#include "./Materials/Matice.h"
#include "./Materials/Matpar.h"

/*Numerics:*/
#include "./Numerics/ElementMatrix.h"
#include "./Numerics/ElementVector.h"

/*Params: */
#include "./Params/BoolParam.h"
#include "./Params/DoubleMatParam.h"
#include "./Params/DoubleTransientMatParam.h"
#include "./Params/DoubleMatArrayParam.h"
#include "./Params/DoubleParam.h"
#include "./Params/DoubleVecParam.h"
#include "./Params/IntParam.h"
#include "./Params/IntVecParam.h"
#include "./Params/IntMatParam.h"
#include "./Params/FileParam.h"
#include "./Params/Param.h"
#include "./Params/PetscMatParam.h"
#include "./Params/PetscVecParam.h"
#include "./Params/StringArrayParam.h"
#include "./Params/StringParam.h"

/*C objects: */
#include "./Contour.h"
#include "./FemModel.h"
#include "./OptArgs.h"
#include "./OptPars.h"

/*Bamg: */
#include "./Bamg/BamgOpts.h"
#include "./Bamg/BamgGeom.h"
#include "./Bamg/BamgMesh.h"
#include "./Bamg/Metric.h"
#include "./Bamg/DoubleAndInt.h"
#include "./Bamg/Direction.h"
#include "./Bamg/BamgVertex.h"
#include "./Bamg/AdjacentTriangle.h"
#include "./Bamg/Edge.h"
#include "./Bamg/GeomVertex.h"
#include "./Bamg/GeomEdge.h"
#include "./Bamg/Curve.h"
#include "./Bamg/Triangle.h"
#include "./Bamg/ListofIntersectionTriangles.h"
#include "./Bamg/GeomSubDomain.h"
#include "./Bamg/SubDomain.h"
#include "./Bamg/VertexOnGeom.h"
#include "./Bamg/VertexOnVertex.h"
#include "./Bamg/VertexOnEdge.h"
#include "./Bamg/CrackedEdge.h"
#include "./Bamg/Mesh.h"
#include "./Bamg/Geometry.h"
#include "./Bamg/QuadTree.h"
#include "./Bamg/SetOfE4.h"

#endif
