md=setmesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',1);

md.timestepping.time_step=1;
md.settings.output_frequency=1;
md.timestepping.final_time=4;

%Set up transient
smb = ones(md.mesh.numberofvertices,1)*3.6;
smb=[ smb smb ];
%md.diagnostic.spcvx=ones(md.mesh.numberofvertices,1);
%md.diagnostic.spcvy=ones(md.mesh.numberofvertices,1);

md.surfaceforcings.mass_balance=smb;
md.surfaceforcings.mass_balance(end+1,:)=[1.5 3];
md.transient.isthermal=0;

%sigma_on_partition=AreaAverageOntoPartition(md,sigma);
%sigma_on_grids=sigma_on_partition(md.part+1); %just to check in case
%md.variables.thickness=normal_uncertain('scaled_Thickness',1,1);
%md.variables.thickness.stddev=sigma_on_partition;

%Dakota inputs,outputs
md.qmu.variables.surface_mass_balance=normal_uncertain('scaled_SurfaceforcingsMassBalance',1,0.1);
%md.qmu.variables.drag_coefficient=normal_uncertain('scaled_FrictionCoefficient',1,0.5);
%md.qmu.variables.rheology_B=normal_uncertain('scaled_MaterialsRheologyB',1,.5);
md.qmu.responses.IceVolume=response_function('IceVolume',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.qmu.responses.MaxVel=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%%  nond_sampling study
md.qmu.method     =dakota_method('nond_samp');
md.qmu.method(end)=dmeth_params_set(md.qmu.method(end),...
'seed',1234,...
'samples',20,...
'sample_type','lhs');

%%  a variety of parameters
md.qmu.params.evaluation_concurrency=1;
md.qmu.params.analysis_driver='';
md.qmu.params.analysis_components='';

%partitioning
md.qmu.numberofpartitions=1;
md=partitioner(md,'package','chaco','npart',md.qmu.numberofpartitions,'weighting','on');
md.qmu.partition=md.qmu.partition-1;
md.qmu.isdakota=1;

md.transient.requested_outputs=IceVolumeEnum();

md.diagnostic.reltol=10^-5; %tighten for qmu analyses
md.debug.valgrind=1;
%md.verbose=verbose('1111111');
%md.verbose.solution=true;
md=solve(md,TransientSolutionEnum,'overwrite','y');
