dnl ISSM Options

AC_DEFUN([ISSM_OPTIONS],[
	dnl Debugging option check.
	AC_ARG_ENABLE([debugging],AS_HELP_STRING([--enable-debugging],
					 [turn debug support on]),
		[enable_debugging=$enableval],[enable_debugging=no])
	if test "x$enable_debugging" = xyes; then
	 AC_DEFINE([_DEBUG_],[1],[Macro to enable debugging in Dakota.])
	fi

	dnl serial build?
	AC_ARG_WITH([serial],
			  AS_HELP_STRING([--with-serial = value],
							 [serial compilation. ]),
			  [SERIAL_VALUE=$withval],[SERIAL_VALUE="yes"])
	AC_MSG_CHECKING(for serial compilation)
	AM_CONDITIONAL([NOSERIAL], [test $SERIAL_VALUE = no])
	AC_MSG_RESULT($SERIAL_VALUE) 
	

	dnl parallel build?
	AC_ARG_WITH([parallel],
			  AS_HELP_STRING([--with-parallel = value],
							 [parallel compilation. ]),
			  [PARALLEL_VALUE=$withval],[PARALLEL_VALUE="yes"])
	AC_MSG_CHECKING(for parallel compilation)
	AM_CONDITIONAL([NOPARALLEL], [test $PARALLEL_VALUE = no])
	AC_MSG_RESULT($PARALLEL_VALUE) 

	dnl: check that at least serial or parallel builds have been requested!
	if test "$SERIAL_VALUE" != "yes" ; then
		if test "$PARALLEL_VALUE" != "yes"; then
		AC_MSG_ERROR([cannot request --with-serial=no and --with-parallel=no at the same time!])
		fi
	fi


	dnl Matlab directory
	AC_ARG_WITH([matlab-dir],
			  AS_HELP_STRING([--with-matlab-dir = DIR],
							 [matlab root directory. necessary for serial build.]),
			 [MATLAB_ROOT=$withval],[MATLAB_ROOT=""]) 
	
	if test -d "$MATLAB_ROOT"; then

		AC_MSG_CHECKING(for Matlab headers and libraries in $MATLAB_ROOT)

		dnl defaults
		HAVE_MATLAB=yes
		MATLABINCL=-I"$MATLAB_ROOT/extern/include";
		dnl  use matlab provided mexext routine to test for extension
		MEXEXT=`$MATLAB_ROOT/bin/mexext`
		MEXEXT=".$MEXEXT"
		MEX=$MATLAB_ROOT/bin/mex

		dnl OS-dependent variables and checks
		case "${host_os}" in
			*linux*)
			if test "${host_cpu}" = "x86_64";
			then
				MEXLIB=-L"$MATLAB_ROOT/bin/glnxa64/ -lmex"
				MEXLINK="-pthread -shared -W2,--version-script,${MATLAB_ROOT}/extern/lib/glnxa64/mexFunction.map";
			else
				MEXLIB=-L"$MATLAB_ROOT/bin/glnx86/ -lmex"
				MEXLINK="-pthread -shared -W2,--version-script,${MATLAB_ROOT}/extern/lib/glnx86/mexFunction.map";
			fi
			;;
		esac

		AC_DEFINE([_HAVE_MATLAB_],[1],[with Matlab in ISSM src])
		AC_SUBST([MATLABINCL])
		AC_SUBST([MEX])
		AC_SUBST([MEXEXT])
		AC_SUBST([MEXLIB]) 
		AC_SUBST([MEXLINK])
	
		AC_MSG_RESULT($HAVE_MATLAB)
	else
		HAVE_MATLAB=no
	fi

	
	if test $HAVE_MATLAB = no; then
		if test "$SERIAL_VALUE" = "yes" ; then
			AC_MSG_ERROR([--with-matlab-dir  missing. Matlab is needed to run ISSM serially!])
		fi
	fi

	dnl get version number
	if test $HAVE_MATLAB = yes; then

		AX_MATLAB_VERSION
		
		dnl  if matlab version is 7.5 and more, and if platform is x86_64, then compile with largearray
		dnl   default is no 
		largearrays=no
		if test $MATLAB_MAJOR -ge 7; then 
			if test $MATLAB_MINOR -ge 5; then 
				if test "${host_cpu}" = "x86_64"; then
					largearrays=yes
				fi
			fi
		fi
	fi
	AM_CONDITIONAL(LARGEARRAYS, test x$largearrays = xyes)
	
	dnl Triangle directory
	AC_ARG_WITH([triangle-dir],
			  AS_HELP_STRING([--with-triangle-dir = DIR], [triangle root directory. necessary for serial build]),
			 [TRIANGLE_ROOT=$withval],[TRIANGLE_ROOT=""]) 
	AC_MSG_CHECKING(for Triangle headers and libraries )
	if test -d "$TRIANGLE_ROOT"; then


		dnl defaults
		HAVE_TRIANGLE=yes
		TRIANGLEINCL=-I$TRIANGLE_ROOT/
		TRIANGLELIB=$TRIANGLE_ROOT/triangle.a

		AC_DEFINE([_HAVE_TRIANGLE_],[1],[with Triangle in ISSM src])
		AC_SUBST([TRIANGLEINCL])
		AC_SUBST([TRIANGLELIB])

	else
		HAVE_TRIANGLE=no
	fi
	AC_MSG_RESULT($HAVE_TRIANGLE)

	AC_MSG_CHECKING(for triangle and parallel status)
	if test $HAVE_TRIANGLE = no; then
		if test "$SERIAL_VALUE" = "yes" ; then
			AC_MSG_ERROR([--with-triangle-dir  missing. Triangle is needed to run ISSM serially!])
		fi
	fi
	AC_MSG_RESULT(ok)

	dnl Dakota directory
	AC_ARG_WITH([dakota-dir],
			  AS_HELP_STRING([--with-dakota-dir = DIR], [dakota root directory. necessary for serial build]),
			 [DAKOTA_ROOT=$withval],[DAKOTA_ROOT=""]) 
	AC_MSG_CHECKING(for Dakota )
	
	if test -d "$DAKOTA_ROOT"; then

		dnl defaults
		HAVE_DAKOTA=yes
		DAKOTAINCL=-I$DAKOTA_ROOT/include
		DAKOTALIB="-L$DAKOTA_ROOT/lib -ldakota -lteuchos -lpecos -lfftw3 -llhs  -levidence -lsurfpack -lconmin -lddace -lfsudace    -ljega -lcport -lopt -lpsuade -lnewmat    -lncsuopt -lgsl -lquadrature -lcoliny -lcolin -lpebbl     -lutilib -l3po -lnappspack -lappspack -lconveyor -lshared -lcdd -lamplsolver "


		AC_DEFINE([_HAVE_DAKOTA_],[1],[with Dakota in ISSM src])
		AC_SUBST([DAKOTAINCL])
		AC_SUBST([DAKOTALIB])

	else
		HAVE_DAKOTA=no
	fi
	AC_MSG_RESULT($HAVE_DAKOTA)

		
	dnl Metis directory
	AC_ARG_WITH([metis-dir],
			  AS_HELP_STRING([--with-metis-dir = DIR],
							 [metis root directory. necessary for serial build]),
			  [METIS_ROOT=$withval],[METIS_ROOT=""])

	if test -d "$METIS_ROOT"; then

		AC_MSG_CHECKING(for Metis headers and libraries in $METIS_ROOT)

		dnl defaults
		HAVE_METIS=yes
		METISINCL=-I"$METIS_ROOT/Lib"
		METISLIB=-L"$METIS_ROOT/ -lmetis"

		AC_DEFINE([_HAVE_METIS_],[1],[with Metis in ISSM src])
		AC_SUBST([METISINCL])
		AC_SUBST([METISLIB])
	else
		HAVE_METIS=no
	fi

	if test $HAVE_METIS = no; then
	AC_MSG_ERROR([--with-metis-dir  missing. Metis is needed to run ISSM]);
	else
	AC_MSG_RESULT($HAVE_METIS)
	fi

	dnl Mpi options!
	AC_MSG_CHECKING(for mpi...)
	AC_ARG_WITH([mpi-lib],
			  AS_HELP_STRING([--with-mpi-lib = otions],
							 [mpi options, for ex: "-L$MPIROOT -lmpich]),
			  [MPILIB=$withval],[MPILIB=""])
	
	AC_ARG_WITH([mpi-include],
			  AS_HELP_STRING([--with-mpi-include = DIR],
							 [mpi include directory, necessary for parallel build]),
			  [MPI_INCLUDE=$withval],[MPI_INCLUDE=""])

	dnl check that --with-mpi-include and --with-mpi-lib have been provided
	if test -z "$MPILIB" ; then
		if test "$PARALLEL_VALUE" = "yes" ; then
			AC_MSG_ERROR([empty --with-mpi-lib options! MPI is needed to run ISSM in paralle!])
		fi
	else
		if test -z "$MPI_INCLUDE" ; then
			if test "$PARALLEL_VALUE" = "yes" ; then
				AC_MSG_ERROR([empty --with-mpi-include directory! MPI is needed to run ISSM in paralle!])
			fi
		else
			HAVE_MPI=yes
			MPIINCL=-I"$MPI_INCLUDE/"
			
			AC_DEFINE([_HAVE_MPI_],[1],[with Mpi in ISSM src])
			AC_DEFINE([HAVE_MPI],[1],[with Mpi in ISSM src])
			AC_SUBST([MPIINCL])
			AC_SUBST([MPILIB])
		fi
	fi
	AC_MSG_RESULT(done)

	dnl Petsc directory and architecture
	AC_ARG_WITH([petsc-dir],
			  AS_HELP_STRING([--with-petsc-dir = DIR],
							 [petsc root directory, necessary for parallel build]),
			  [PETSC_ROOT=$withval],[PETSC_ROOT=""])

	if test "$PARALLEL_VALUE" = "yes" ; then
		if test "$PETSC_ROOT" = "" ; then
			AC_MSG_ERROR([missing --with-petsc-dir argument for parallel compilation!])
		fi
	fi
	
	AC_ARG_WITH([petsc-arch],
			  AS_HELP_STRING([--with-petsc-arch = DIR],
							 [petsc arch , necessary for parallel build]),
			  [PETSC_ARCH=$withval],[PETSC_ARCH=""])

	if test "$PARALLEL_VALUE" = "yes" ; then
		if test "$PETSC_ARCH" = "" ; then
			AC_MSG_ERROR([missing --with-petsc-arch argument for parallel compilation!])
		fi
	fi
	
	AC_MSG_CHECKING(for Petsc headers and libraries in $PETSC_ROOT for architecture $PETSC_ARCH)
	
	if test -d "$PETSC_ROOT"; then

		if test -d "$PETSC_ROOT/bmake/$PETSC_ARCH"; then
		
			PETSCINCL="-I$PETSC_ROOT/include  -I$PETSC_ROOT/ -I$PETSC_ROOT/bmake/$PETSC_ARCH -I$PETSC_ROOT/src/mat/impls/dense/mpi/plapack/"
			PETSCLIB="-L$PETSC_ROOT/lib/$PETSC_ARCH -lpetscksp -lpetscdm -lpetscmat -lpetscvec -lpetsc  -lpetscsnes -lpetscts"
			                          


			AC_DEFINE([_HAVE_PETSC_],[1],[with Petsc in ISSM src])
			AC_SUBST([PETSCINCL])
			AC_SUBST([PETSCLIB])

			HAVE_PETSC=yes
		else
			HAVE_PETSC=no
		fi
	else
		HAVE_PETSC=no
	fi

	if test $HAVE_PETSC = no; then
		if test "$PARALLEL_VALUE" = "yes" ; then
			AC_MSG_ERROR([could not find petsc. user should specify --with-petsc-dir and --with-petsc-arch options. Petsc is needed to run ISSM in paralle!])
		fi
	else
		AC_MSG_RESULT($HAVE_PETSC)
	fi


	dnl Slepc directory
	AC_ARG_WITH([slepc-dir],
			  AS_HELP_STRING([--with-slepc-dir = DIR],
							 [slepc root directory]),
			  [SLEPC_ROOT=$withval],[SLEPC_ROOT=""])
			  
	AC_MSG_CHECKING(for Slepc headers and libraries in $SLEPC_ROOT)
	if test -d "$SLEPC_ROOT"; then


		dnl defaults
		HAVE_SLEPC=yes
		SLEPCINCL=-I"$SLEPC_ROOT/include"
		SLEPCLIB=-L"$SLEPC_ROOT/lib/ -lslepc"

		AC_DEFINE([_HAVE_SLEPC_],[1],[with Slepc in ISSM src])
		AC_SUBST([SLEPCINCL])
		AC_SUBST([SLEPCLIB])
	else
		HAVE_SLEPC=no
	fi
	AC_MSG_RESULT($HAVE_SLEPC)
	
	dnl Scalapack directory
	AC_ARG_WITH([scalapack-dir],
			  AS_HELP_STRING([--with-scalapack-dir = DIR],
							 [scalapack root directory]),
			  [SCALAPACK_ROOT=$withval],[SCALAPACK_ROOT=""])
			  
	AC_MSG_CHECKING(for Scalapack headers and libraries in $SCALAPACK_ROOT)
	if test -d "$SCALAPACK_ROOT"; then


		dnl defaults
		HAVE_SCALAPACK=yes
		SCALAPACKLIB=-L"$SCALAPACK_ROOT/ -lscalapack"

		AC_DEFINE([_HAVE_SCALAPACK_],[1],[with Scalapack in ISSM src])
		AC_SUBST([SCALAPACKLIB])
	else
		HAVE_SCALAPACK=no
	fi
	AC_MSG_RESULT($HAVE_SCALAPACK)

	dnl Blas-lapack directory
	AC_ARG_WITH([blas-lapack-dir],
			  AS_HELP_STRING([--with-blas-lapack-dir = DIR],
							 [blas-lapack root directory]),
			  [BLASLAPACK_ROOT=$withval],[BLASLAPACK_ROOT=""])
			  
	AC_MSG_CHECKING(for Blas and Lapack headers and libraries in $BLASLAPACK_ROOT)
	if test -d "$BLASLAPACK_ROOT"; then


		dnl defaults
		HAVE_BLASLAPACK=yes
		BLASLAPACKINCL=""
		dnl BLASLAPACKLIB=-L"$BLASLAPACK_ROOT -lmkl_lapack -lmkl -lguide"
		BLASLAPACKLIB=-L"$BLASLAPACK_ROOT -lfblas -lflapack"

		AC_DEFINE([_HAVE_BLASLAPACK_],[1],[with blas lapack in ISSM src])
		AC_SUBST([BLASLAPACKLIB])
		AC_SUBST([BLASLAPACKINCL])
	else
		HAVE_BLASLAPACK=no
	fi
	AC_MSG_RESULT($HAVE_BLASLAPACK)

	dnl mkl directory
	AC_ARG_WITH([mkl-dir],
			  AS_HELP_STRING([--with-mkl-dir = DIR],
							 [mkl root directory]),
			  [MKL_ROOT=$withval],[MKL_ROOT=""])
			  
	AC_MSG_CHECKING(for mkl headers and libraries in $MKL_ROOT)
	if test -d "$MKL_ROOT"; then

		dnl defaults
		HAVE_MKL=yes
		MKLINCL=""
		MKLLIB=-L"$MKL_ROOT -lmkl_lapack -lmkl -lguide"

		AC_DEFINE([_HAVE_MKL_],[1],[with mkl in ISSM src])
		AC_SUBST([MKLLIB])
		AC_SUBST([MKLINCL])
	else
		HAVE_MKL=no
	fi
	AC_MSG_RESULT($HAVE_MKL)

	dnl Plapack directory
	AC_ARG_WITH([plapack-dir],
			  AS_HELP_STRING([--with-plapack-dir = DIR],
							 [plapack root directory]),
			  [PLAPACK_ROOT=$withval],[PLAPACK_ROOT=""])
			  
	AC_MSG_CHECKING(for Plapack headers and libraries in $PLAPACK_ROOT)
	if test -d "$PLAPACK_ROOT"; then


		dnl defaults
		HAVE_PLAPACK=yes
		PLAPACKINCL=-I"$PLAPACK_ROOT/INCLUDE"
		PLAPACKLIB=-L"$PLAPACK_ROOT/ -lPLAPACK"

		AC_DEFINE([_HAVE_PLAPACK_],[1],[with Plapack in ISSM src])
		AC_SUBST([PLAPACKINCL])
		AC_SUBST([PLAPACKLIB])
	else
		HAVE_PLAPACK=no
	fi
	AC_MSG_RESULT($HAVE_PLAPACK)

	dnl Mumps directory
	AC_ARG_WITH([mumps-dir],
			  AS_HELP_STRING([--with-mumps-dir = DIR],
							 [mumps root directory]),
			  [MUMPS_ROOT=$withval],[MUMPS_ROOT=""])
			  
	AC_MSG_CHECKING(for Mumps headers and libraries in $MUMPS_ROOT)
	if test -d "$MUMPS_ROOT"; then

		dnl defaults
		HAVE_MUMPS=yes
		MUMPSINCL=-I"$MUMPS_ROOT/include"
		MUMPSLIB=-L"$MUMPS_ROOT/lib -ldmumps -lcmumps -lpord"

		AC_DEFINE([_HAVE_MUMPS_],[1],[with Mumps in ISSM src])
		AC_SUBST([MUMPSINCL])
		AC_SUBST([MUMPSLIB])
	else
		HAVE_MUMPS=no
	fi
	AC_MSG_RESULT($HAVE_MUMPS)

	dnl Blacs directory
	AC_ARG_WITH([blacs-dir],
			  AS_HELP_STRING([--with-blacs-dir = DIR],
							 [blacs root directory]),
			  [BLACS_ROOT=$withval],[BLACS_ROOT=""])
			  
	AC_MSG_CHECKING(for Blacs headers and libraries in $BLACS_ROOT)
	if test -d "$BLACS_ROOT"; then

		dnl defaults
		HAVE_BLACS=yes
		BLACSINCL=""
		BLACSLIB=-L"$BLACS_ROOT/ -lblacs"
        
		AC_DEFINE([_HAVE_BLACS_],[1],[with Blacs in ISSM src])
		AC_SUBST([BLACSINCL])
		AC_SUBST([BLACSLIB])
	else
		HAVE_BLACS=no
	fi
	AC_MSG_RESULT($HAVE_BLACS)




])
