/*!\file KML_Icon.cpp
 * \brief: implementation of the kml_feature abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Icon::KML_Icon(){{{1*/
KML_Icon::KML_Icon(){

	strcpy(href      ,"");
	strcpy(refmode   ,"onChange");
	refint    = 4.;
	strcpy(vrefmode  ,"never");
	vreftime  = 4.;
	vboundsc  = 1.;
	strcpy(vformat   ,"");
	strcpy(hquery    ,"");

}
/*}}}*/
/*FUNCTION KML_Icon::~KML_Icon(){{{1*/
KML_Icon::~KML_Icon(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Icon::Echo {{{1*/
void  KML_Icon::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Icon:\n");
	KML_Object::Echo();

	_printf_(flag,"          href: \"%s\"\n"    ,href);
	_printf_(flag,"       refmode: \"%s\"\n"    ,refmode);
	_printf_(flag,"        refint: %g\n"        ,refint);
	_printf_(flag,"      vrefmode: \"%s\"\n"    ,vrefmode);
	_printf_(flag,"      vreftime: %g\n"        ,vreftime);
	_printf_(flag,"      vboundsc: %g\n"        ,vboundsc);
	_printf_(flag,"       vformat: \"%s\"\n"    ,vformat);
	_printf_(flag,"        hquery: \"%s\"\n"    ,hquery);

	return;
}
/*}}}*/

/*FUNCTION KML_Icon::DeepEcho {{{1*/
void  KML_Icon::DeepEcho(){

	char  indent[81]="";

	KML_Icon::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Icon::DeepEcho {{{1*/
void  KML_Icon::DeepEcho(char* indent){

	bool  flag=true;

	_printf_(flag,"%sKML_Icon:\n",indent);
	KML_Object::DeepEcho(indent);

	_printf_(flag,"%s          href: \"%s\"\n"    ,indent,href);
	_printf_(flag,"%s       refmode: \"%s\"\n"    ,indent,refmode);
	_printf_(flag,"%s        refint: %g\n"        ,indent,refint);
	_printf_(flag,"%s      vrefmode: \"%s\"\n"    ,indent,vrefmode);
	_printf_(flag,"%s      vreftime: %g\n"        ,indent,vreftime);
	_printf_(flag,"%s      vboundsc: %g\n"        ,indent,vboundsc);
	_printf_(flag,"%s       vformat: \"%s\"\n"    ,indent,vformat);
	_printf_(flag,"%s        hquery: \"%s\"\n"    ,indent,hquery);

	return;
}
/*}}}*/

/*FUNCTION KML_Icon::Write {{{1*/
void  KML_Icon::Write(FILE* filout,char* indent){

	fprintf(filout,"%s<Icon",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Object::Write(filout,indent);

	if (href     && strlen(href))
		fprintf(filout,"%s  <href>%s</href>\n",indent,href);
	if (refmode  && strlen(refmode))
		fprintf(filout,"%s  <refreshMode>%s</refreshMode>\n",indent,refmode);
	fprintf(filout,"%s  <refreshInterval>%g</refreshInterval>\n",indent,refint);
	if (vrefmode && strlen(vrefmode))
		fprintf(filout,"%s  <viewRefreshMode>%s</viewRefreshMode>\n",indent,vrefmode);
	fprintf(filout,"%s  <viewRefreshTime>%g</viewRefreshTime>\n",indent,vreftime);
	fprintf(filout,"%s  <viewBoundScale>%g</viewBoundScale>\n",indent,vboundsc);
	if (vformat  && strlen(vformat))
		fprintf(filout,"%s  <viewFormat>%s</viewFormat>\n",indent,vformat);
	if (hquery   && strlen(hquery))
		fprintf(filout,"%s  <httpQuery>%s</httpQuery>\n",indent,hquery);

	fprintf(filout,"%s</Icon>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Icon::Read {{{1*/
void  KML_Icon::Read(FILE* fid,char* kstr){

	char*        kstri;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</Icon", 6)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Icon::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Icon::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<href>"))
			KMLFileTokenParse( href      ,NULL,KML_ICON_HREF_LENGTH,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<refreshMode>"))
			KMLFileTokenParse( refmode   ,NULL,KML_ICON_REFMODE_LENGTH,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<refreshInterval>"))
			KMLFileTokenParse(&refint    ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<viewRefreshMode>"))
			KMLFileTokenParse( vrefmode  ,NULL,KML_ICON_VREFMODE_LENGTH,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<viewRefreshTime>"))
			KMLFileTokenParse(&vreftime  ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<viewBoundScale>"))
			KMLFileTokenParse(&vboundsc  ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<viewFormat>"))
			KMLFileTokenParse( vformat   ,NULL,KML_ICON_VFORMAT_LENGTH,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<httpQuery>"))
			KMLFileTokenParse( hquery    ,NULL,KML_ICON_HQUERY_LENGTH,
							  kstri,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_Object::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

