/*!\file KML_LineString.cpp
 * \brief: implementation of the kml_linestring object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
#include "../../modules/Ll2xyx/Ll2xyx.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_LineString::KML_LineString(){{{1*/
KML_LineString::KML_LineString(){

	extrude   =false;
	tessellate=false;
	memcpy(altmode,"clampToGround",(strlen("clampToGround")+1)*sizeof(char));

	ncoord    =0;
	coords    =NULL;

}
/*}}}*/
/*FUNCTION KML_LineString::~KML_LineString(){{{1*/
KML_LineString::~KML_LineString(){

	if (coords) xfree((void**)&coords);

	coords    =NULL;
	ncoord    =0;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_LineString::Echo {{{1*/
void  KML_LineString::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_LineString:\n");
	KML_Geometry::Echo();

	_printf_(flag,"       extrude: %s\n"          ,(extrude ? "true" : "false"));
	_printf_(flag,"    tessellate: %s\n"          ,(tessellate ? "true" : "false"));
	_printf_(flag,"       altmode: \"%s\"\n"      ,altmode);
	_printf_(flag,"        coords: (ncoord=%d)\n" ,ncoord);

	return;
}
/*}}}*/

/*FUNCTION KML_LineString::DeepEcho {{{1*/
void  KML_LineString::DeepEcho(){

	char  indent[81]="";

	KML_LineString::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LineString::DeepEcho {{{1*/
void  KML_LineString::DeepEcho(char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%sKML_LineString:\n",indent);
	KML_Geometry::DeepEcho(indent);

	_printf_(flag,"%s       extrude: %s\n"          ,indent,(extrude ? "true" : "false"));
	_printf_(flag,"%s    tessellate: %s\n"          ,indent,(tessellate ? "true" : "false"));
	_printf_(flag,"%s       altmode: \"%s\"\n"      ,indent,altmode);
	_printf_(flag,"%s        coords: (ncoord=%d)\n" ,indent,ncoord);
	for (i=0; i<ncoord; i++)
		_printf_(flag,"%s                (%g,%g,%g)\n" ,indent,
				coords[i][0],coords[i][1],coords[i][2]);

	return;
}
/*}}}*/

/*FUNCTION KML_LineString::Write {{{1*/
void  KML_LineString::Write(FILE* filout,char* indent){

	int   i;

	fprintf(filout,"%s<LineString",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Geometry::Write(filout,indent);

	fprintf(filout,"%s  <extrude>%d</extrude>\n",indent,(extrude ? 1 : 0));
	fprintf(filout,"%s  <tessellate>%d</tessellate>\n",indent,(tessellate ? 1 : 0));
	fprintf(filout,"%s  <altitudeMode>%s</altitudeMode>\n",indent,altmode);
	fprintf(filout,"%s  <coordinates>\n",indent);

/*  loop over the coordinates for the linestring  */

	for (i=0; i<ncoord; i++)
		fprintf(filout,"%s    %0.16g,%0.16g,%0.16g\n",indent,
				coords[i][0],coords[i][1],coords[i][2]);

	fprintf(filout,"%s  </coordinates>\n",indent);
	fprintf(filout,"%s</LineString>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LineString::Read {{{1*/
void  KML_LineString::Read(FILE* fid,char* kstr){

	char*        kstri;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</LineString",12)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_LineString::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_LineString::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<extrude>"))
			KMLFileTokenParse(&extrude   ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<tessellate>"))
			KMLFileTokenParse(&tessellate,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<altitudeMode>"))
			KMLFileTokenParse( altmode   ,NULL,KML_LINESTRING_ALTMODE_LENGTH,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<coordinates>"))
			KMLFileTokenParse(&coords    ,&ncoord    ,0,
							  kstri,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_Geometry::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

/*FUNCTION KML_LineString::WriteExp {{{1*/
void  KML_LineString::WriteExp(FILE* fid,char* nstr,int sgn,double cm,double sp){

	int     i;
	double  *lat,*lon,*x,*y;
	char    nstr2[81];

/*  extract latitude and longitude into vectors  */

	lat=(double *) xmalloc(ncoord*sizeof(double));
	lon=(double *) xmalloc(ncoord*sizeof(double));
	for (i=0; i<ncoord; i++) {
		lon[i]=coords[i][0];
		lat[i]=coords[i][1];
	}

/*  convert latitude and longitude to x and y  */

	x  =(double *) xmalloc(ncoord*sizeof(double));
	y  =(double *) xmalloc(ncoord*sizeof(double));
	Ll2xyx(x,y,lat,lon,ncoord,sgn,cm,sp);

/*  write header  */

	memcpy(nstr2,nstr,(strlen(nstr)+1)*sizeof(char));

	for (i=0; i<strlen(nstr2); i++)
		if ((nstr2[i] == ' ') || (nstr2[i] == '\t'))
			nstr2[i]='_';
	fprintf(fid,"## Name:%s\n",nstr2);
	fprintf(fid,"## Icon:0\n");
	fprintf(fid,"# Points Count	Value\n");
    fprintf(fid,"%u	%s\n",ncoord  ,"1.");
	fprintf(fid,"# X pos	Y pos\n");

/*  write vertices  */

	for (i=0; i<ncoord; i++)
	    fprintf(fid,"%lf\t%lf\n",x[i],y[i]);

/*  write blank line  */

	fprintf(fid,"\n");

	xfree((void**)&y);
	xfree((void**)&x);
	xfree((void**)&lon);
	xfree((void**)&lat);

	return;
}
/*}}}*/

