/*!\file KML_LatLonBox.cpp
 * \brief: implementation of the kml_feature abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_LatLonBox::KML_LatLonBox(){{{1*/
KML_LatLonBox::KML_LatLonBox(){

	north     = 0.;
	south     = 0.;
	east      = 0.;
	west      = 0.;
	rotation  = 0.;

}
/*}}}*/
/*FUNCTION KML_LatLonBox::~KML_LatLonBox(){{{1*/
KML_LatLonBox::~KML_LatLonBox(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_LatLonBox::Echo {{{1*/
void  KML_LatLonBox::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_LatLonBox:\n");
	KML_Object::Echo();

	_printf_(flag,"         north: %0.16g\n"    ,north);
	_printf_(flag,"         south: %0.16g\n"    ,south);
	_printf_(flag,"          east: %0.16g\n"    ,east);
	_printf_(flag,"          west: %0.16g\n"    ,west);
	_printf_(flag,"      rotation: %0.16g\n"    ,rotation);

	return;
}
/*}}}*/

/*FUNCTION KML_LatLonBox::DeepEcho {{{1*/
void  KML_LatLonBox::DeepEcho(){

	char  indent[81]="";

	KML_LatLonBox::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LatLonBox::DeepEcho {{{1*/
void  KML_LatLonBox::DeepEcho(char* indent){

	bool  flag=true;

	_printf_(flag,"%sKML_LatLonBox:\n",indent);
	KML_Object::DeepEcho(indent);

	_printf_(flag,"%s         north: %0.16g\n"    ,indent,north);
	_printf_(flag,"%s         south: %0.16g\n"    ,indent,south);
	_printf_(flag,"%s          east: %0.16g\n"    ,indent,east);
	_printf_(flag,"%s          west: %0.16g\n"    ,indent,west);
	_printf_(flag,"%s      rotation: %0.16g\n"    ,indent,rotation);

	return;
}
/*}}}*/

/*FUNCTION KML_LatLonBox::Write {{{1*/
void  KML_LatLonBox::Write(FILE* filout,char* indent){

	fprintf(filout,"%s<LatLonBox",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Object::Write(filout,indent);

	fprintf(filout,"%s  <north>%0.16g</north>\n",indent,north);
	fprintf(filout,"%s  <south>%0.16g</south>\n",indent,south);
	fprintf(filout,"%s  <east>%0.16g</east>\n",indent,east);
	fprintf(filout,"%s  <west>%0.16g</west>\n",indent,west);
	fprintf(filout,"%s  <rotation>%0.16g</rotation>\n",indent,rotation);

	fprintf(filout,"%s</LatLonBox>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LatLonBox::Read {{{1*/
void  KML_LatLonBox::Read(FILE* fid,char* kstr){

	char*        kstri;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</LatLonBox",11)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_LatLonBox::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_LatLonBox::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<north>"))
			KMLFileTokenParse(&north     ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<south>"))
			KMLFileTokenParse(&south     ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<east>"))
			KMLFileTokenParse(&east      ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<west>"))
			KMLFileTokenParse(&west      ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<rotation>"))
			KMLFileTokenParse(&rotation  ,
							  kstri,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_Object::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

