/*!\file KML_Polygon.cpp
 * \brief: implementation of the kml_polygon object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Polygon::KML_Polygon(){{{1*/
KML_Polygon::KML_Polygon(){

	extrude   =false;
	tessellate=false;
	memcpy(altmode,"clampToGround",(strlen("clampToGround")+1)*sizeof(char));

	outer     =new DataSet;
	inner     =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Polygon::~KML_Polygon(){{{1*/
KML_Polygon::~KML_Polygon(){

	if (inner) {
		delete inner;
		inner     =NULL;
	}

	if (outer) {
		delete outer;
		outer     =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Polygon::Echo {{{1*/
void  KML_Polygon::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Polygon:\n");
	KML_Geometry::Echo();

	_printf_(flag,"       extrude: %s\n"          ,(extrude ? "true" : "false"));
	_printf_(flag,"    tessellate: %s\n"          ,(tessellate ? "true" : "false"));
	_printf_(flag,"       altmode: \"%s\"\n"      ,altmode);
	_printf_(flag,"         outer: (size=%d)\n"   ,outer->Size());
	_printf_(flag,"         inner: (size=%d)\n"   ,inner->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::DeepEcho {{{1*/
void  KML_Polygon::DeepEcho(){

	char  indent[81]="";

	KML_Polygon::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::DeepEcho {{{1*/
void  KML_Polygon::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Polygon:\n",indent);
	KML_Geometry::DeepEcho(indent);

	_printf_(flag,"%s       extrude: %s\n"          ,indent,(extrude ? "true" : "false"));
	_printf_(flag,"%s    tessellate: %s\n"          ,indent,(tessellate ? "true" : "false"));
	_printf_(flag,"%s       altmode: \"%s\"\n"      ,indent,altmode);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	if (outer->Size())
		for (i=0; i<outer->Size(); i++) {
			_printf_(flag,"%s         outer: -------- begin [%d] --------\n" ,indent,i);
			((KML_LinearRing *)outer->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s         outer: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s         outer: [empty]\n"    ,indent);

	if (inner->Size())
		for (i=0; i<inner->Size(); i++) {
			_printf_(flag,"%s         inner: -------- begin [%d] --------\n" ,indent,i);
			((KML_LinearRing *)inner->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s         inner: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s         inner: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::Write {{{1*/
void  KML_Polygon::Write(FILE* filout,char* indent){

	int   i;
	char  indent4[81];

	fprintf(filout,"%s<Polygon",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Geometry::Write(filout,indent);

	fprintf(filout,"%s  <extrude>%d</extrude>\n",indent,(extrude ? 1 : 0));
	fprintf(filout,"%s  <tessellate>%d</tessellate>\n",indent,(tessellate ? 1 : 0));
	fprintf(filout,"%s  <altitudeMode>%s</altitudeMode>\n",indent,altmode);

	memcpy(indent4,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent4,"    ");

/*  check outer boundary for the polygon  */

	fprintf(filout,"%s  <outerBoundaryIs>\n",indent);
	if (outer->Size())
		((KML_LinearRing *)outer->GetObjectByOffset(0))->Write(filout,indent4);
	fprintf(filout,"%s  </outerBoundaryIs>\n",indent);

/*  loop over any inner boundaries for the polygon  */

	for (i=0; i<inner->Size(); i++) {
		fprintf(filout,"%s  <innerBoundaryIs>\n",indent);
		((KML_LinearRing *)inner->GetObjectByOffset(i))->Write(filout,indent4);
		fprintf(filout,"%s  </innerBoundaryIs>\n",indent);
	}

	fprintf(filout,"%s</Polygon>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::Read {{{1*/
void  KML_Polygon::Read(FILE* fid,char* kstr){

	char*        kstri;
	char*        kstrj;
	KML_Object*  kobj;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</Polygon", 9)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Polygon::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Polygon::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<extrude>"))
			KMLFileTokenParse(&extrude   ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<tessellate>"))
			KMLFileTokenParse(&tessellate,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<altitudeMode>"))
			KMLFileTokenParse( altmode   ,NULL,KML_POLYGON_ALTMODE_LENGTH,
							  kstri,
							  fid);

		else if (!strcmp(kstri,"<outerBoundaryIs>"))

/*  loop over and process fields within outer boundary  */

			while (kstrj=KMLFileToken(fid)) {
				if      (!strncmp(kstrj,"</outerBoundaryIs",17)) {
					xfree((void**)&kstrj);
					break;
				}
				else if (!strncmp(kstrj,"</",2))
					_error_("KML_Polygon::Read -- Unexpected closing tag %s.\n",kstrj);
				else if (strncmp(kstrj,"<",1))
					_error_("KML_Polygon::Read -- Unexpected field \"%s\".\n",kstrj);

				else if (!strncmp(kstrj,"<LinearRing",11)) {
					kobj=(KML_Object*)new KML_LinearRing();
					kobj->Read(fid,kstrj);
					outer     ->AddObject((Object*)kobj);
				}

				else if (!strncmp(kstrj,"<",1))
					KML_Geometry::Read(fid,kstrj);

				xfree((void**)&kstrj);
			}

		else if (!strcmp(kstri,"<innerBoundaryIs>"))

/*  loop over and process fields within inner boundaries  */

			while (kstrj=KMLFileToken(fid)) {
				if      (!strncmp(kstrj,"</innerBoundaryIs",17)) {
					xfree((void**)&kstrj);
					break;
				}
				else if (!strncmp(kstrj,"</",2))
					_error_("KML_Polygon::Read -- Unexpected closing tag %s.\n",kstrj);
				else if (strncmp(kstrj,"<",1))
					_error_("KML_Polygon::Read -- Unexpected field \"%s\".\n",kstrj);

				else if (!strncmp(kstrj,"<LinearRing",11)) {
					kobj=(KML_Object*)new KML_LinearRing();
					kobj->Read(fid,kstrj);
					inner     ->AddObject((Object*)kobj);
				}

				else if (!strncmp(kstrj,"<",1))
					KML_Geometry::Read(fid,kstrj);

				xfree((void**)&kstrj);
			}


		else if (!strncmp(kstri,"<",1))
			KML_Geometry::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::WriteExp {{{1*/
void  KML_Polygon::WriteExp(FILE* fid,char* nstr,int sgn,double cm,double sp){

	int   i;
	char  nstr2[81];

/*  check outer boundary for the polygon  */

	if (outer->Size()) {
		if (strlen(nstr))
			sprintf(nstr2,"%s (outer)",nstr);
		else
			sprintf(nstr2,"(outer)");

		((KML_LinearRing *)outer->GetObjectByOffset(0))->WriteExp(fid,nstr2,sgn,cm,sp);
	}

/*  loop over any inner boundaries for the polygon  */

	for (i=0; i<inner->Size(); i++) {
		if (strlen(nstr))
			sprintf(nstr2,"%s (inner %d of %d)",nstr,i+1,inner->Size());
		else
			sprintf(nstr2,"(inner %d of %d)",i+1,inner->Size());

		((KML_LinearRing *)inner->GetObjectByOffset(i))->WriteExp(fid,nstr2,sgn,cm,sp);
	}

	return;
}
/*}}}*/

