%-----------------------------------------------------------------------
%	CreateFEMModel.m: from a matlab ISSM @model class object, create a finite element 
%                  model structure, with "c" code datasets (elements, nodes, loads,  constraints, 
%                  parameters, partitioning vectors.
%
%-----------------------------------------------------------------------

function  m=CreateFEMModel(md)

	disp(sprintf('\n   reading data from model %s...',md.name));
	[m.elements,m.nodes,m.constraints,m.loads,m.materials,parameters]=ModelProcessor(md);
	
	disp('   generating degrees of freedom...');
	[m.nodes,m.part,m.tpart]=Dof(m.elements,m.nodes,parameters);
	
	disp('   generating single point constraints...');
	[m.nodes,m.yg]=SpcNodes(m.nodes,m.constraints);

	disp('   generating rigid body constraints...');
	[m.Rmg,m.nodes]=MpcNodes(m.nodes,m.constraints);

	disp('   generating node sets...');
	m.nodesets=BuildNodeSets(m.nodes);

	disp('   reducing single point constraints vector...');
	[m.ys m.ys0]=Reducevectorgtos(m.yg,m.nodesets);

	disp('   normalizing rigid body constraints matrix...');
	m.Gmn = NormalizeConstraints(m.Rmg,m.nodesets);
	
	disp('   configuring element and loads...');
	[m.elements,m.loads,m.nodes] = ConfigureObjects( m.elements, m.loads, m.nodes, m.materials);
	
	disp('   processing parameters...');
	parameters= ProcessParams(parameters,m.part);

	disp('   creating parameters in matlab workspace...');
	m.parameters= ParamsToWorkspace(parameters);

	%Get rid of parameters dataset. 
	clear parameters;

end
