/*!\file Node.h
 * \brief: header file for node object
 */

#ifndef _NODE_H_
#define _NODE_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../shared/shared.h"
class  Inputs;
class  Hook;
class  DofIndexing;
class  IoModel;
class  DataSet;
class  Vertices;
#include "./Update.h"
/*}}}*/

class Node: public Object ,public Update{

	public: 

		int	    id;  //unique arbitrary id.
		int     sid; //sid for "serial" id, ie the rank of this node in the nodes dataset, if the dataset was serial on 1 cpu.
				
		DofIndexing    indexing;
		Hook*          hvertex;
		Inputs*        inputs; //properties of this node
		int            analysis_type;
		double         coord_system[3][3];

		/*Node constructors, destructors {{{1*/
		Node();
		Node(int node_id,int node_sid, int vertex_id,int io_index, IoModel* iomodel,int analysis_type);
		~Node();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy(){_error_("Not implemented yet (similar to Elements)");};
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(double* matrix,int nrows, int ncols, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution){_error_("Not implemented yet!");}
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("Not implemented yet!");}
		/*}}}*/
		/*Node numerical routines {{{1*/
		void   Configure(DataSet* nodes,Vertices* vertices);
		void   CreateNodalConstraints(Vec ys);
		void   SetCurrentConfiguration(DataSet* nodes,Vertices* vertices);
		int    Sid(void); 
		int    GetVertexDof(void);
		int    GetVertexId(void);
#ifdef _HAVE_DIAGNOSTIC_
		void   GetCoordinateSystem(double* coord_system_out);
#endif
		void   SetVertexDof(int in_dof);
		bool   InAnalysis(int analysis_type);
		int    GetApproximation();
		int    GetNumberOfDofs(int approximation_enum,int setenum);
		int    IsClone();
		void   ApplyConstraint(int dof,double value);
		void   RelaxConstraint(int dof);
		void   DofInSSet(int dof);
		void   DofInFSet(int dof);
		int    GetDof(int dofindex,int setenum);
		void   CreateVecSets(Vec pv_g,Vec pv_f,Vec pv_s);
		int    GetConnectivity();
		void   GetDofList(int* poutdoflist,int approximation_enum,int setenum);
		void   GetLocalDofList(int* poutdoflist,int approximation_enum,int setenum);
		int    GetDofList1(void);
		int    GetSidList(void);
		double GetX();
		double GetY();
		double GetZ();
		double GetSigma();
		int    IsOnBed();
		int    IsOnSurface();
		void   FreezeDof(int dof);
		int    IsFloating();
		int    IsGrounded();
		void   UpdateSpcs(double* ys);
		void   VecMerge(Vec ug, double* vector_serial,int setnum);
		void   VecReduce(Vec vector, double* ug_serial,int setnum);
		
		/*}}}*/
		/*Dof Object routines {{{1*/
		void  DistributeDofs(int* pdofcount,int setenum);
		void  OffsetDofs(int dofcount,int setenum);
		void  ShowTrueDofs(int* truerows,int ncols,int setenum);
		void  UpdateCloneDofs(int* alltruerows,int ncols,int setenum);
		void  SetClone(int* minranks);
		/*}}}*/
};

#endif  /* _NODE_H_ */
