/*\file AddExternalResult.c
 *\brief: output results inside elements, and in femmodel
 */

#include "./AddExternalResult.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	DataSet* results=NULL;
	int      type,ncols,nraws;
	double*  value=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&AddExternalResultUsage);

	/*Input datasets: */
	FetchMatlabData(&results,RESULTS);
	FetchMatlabData(&type,TYPE);
	FetchMatlabData(&value,&nraws,&ncols,VALUE);

	/*results might be NILL, allocate: */
	if(!results)results=new Results();

	/*Find class of the value and call the right AddExternalResultx*/
	if(nraws==1 && ncols==1){  //scalar result
		AddExternalResultx(results, type, value[0]);
	}
	else if(nraws>1 && ncols==1){  //vector result
		AddExternalResultx(results, type, value, nraws);
	}
	else{
		_error_("type of result not implemented yet in AddExternalResult");
	}

	/*write output datasets: */
	WriteMatlabData(RESULTSOUT,results);
	
	/*Free ressources: */
	delete results;

	/*end module: */
	MODULEEND();
}

void AddExternalResultUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [results] = %s(results,type,value);\n",__FUNCT__);
	_printf_(true,"\n");
}
