/*
 * \file Materials.c
 * \brief: implementation of the Materials class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Materials::Materials(){{{1*/
Materials::Materials(){
	enum_type=MaterialsEnum;
	return;
}
/*}}}*/
/*FUNCTION Materials::~Materials(){{{1*/
Materials::~Materials(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Materials::Configure{{{1*/
void Materials::Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters){

	vector<Object*>::iterator object;
	Material* material=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		material=(Material*)(*object);
		material->Configure(elements);

	}

}
/*}}}*/
