/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

#include "../modules/EnumToStringx/EnumToStringx.h"
#include "../modules/StringToEnumx/StringToEnumx.h"

enum definitions{
	/*Model fields {{{1*/
	AutodiffForwardEnum,
	AutodiffIsautodiffEnum, 
	AutodiffReverseEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsMeltingRateEnum,
	BathymetryEnum,
	BedEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DiagnosticAbstolEnum,
	DiagnosticIcefrontEnum,
	DiagnosticMaxiterEnum,
	DiagnosticNumRequestedOutputsEnum,
	DiagnosticPenaltyFactorEnum,
	DiagnosticReferentialEnum,
	DiagnosticReltolEnum,
	DiagnosticRequestedOutputsEnum,
	DiagnosticRestolEnum,
	DiagnosticRiftPenaltyLockEnum,
	DiagnosticRiftPenaltyThresholdEnum,
	DiagnosticShelfDampeningEnum,
	DiagnosticSpcvxEnum,
	DiagnosticSpcvyEnum,
	DiagnosticSpcvzEnum,
	DiagnosticStokesreconditioningEnum,
	DiagnosticVertexPairingEnum,
	DiagnosticViscosityOvershootEnum,
	FlowequationBordermacayealEnum,
	FlowequationBorderpattynEnum,
	FlowequationBorderstokesEnum,
	FlowequationElementEquationEnum,
	FlowequationIshutterEnum,
	FlowequationIsmacayealpattynEnum,
	FlowequationIsstokesEnum,
	FlowequationVertexEquationEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyCREnum,
	HydrologyKnEnum,
	HydrologyNEnum,
	HydrologyPEnum,
	HydrologyQEnum,
	HydrologySpcwatercolumnEnum,
	HydrologyStabilizationEnum,
	InversionControlParametersEnum,
	InversionCostFunctionEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientOnlyEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskElementonfloatingiceEnum,
	MaskElementongroundediceEnum,
	MaskElementonwaterEnum,
	MaskVertexonfloatingiceEnum,
	MaskVertexongroundediceEnum,
	MaskVertexonwaterEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshDimensionEnum,
	MeshEdgesEnum,
	MeshElementconnectivityEnum,
	MeshElementonbedEnum,
	MeshElementonsurfaceEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofedgesEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbedEnum,
	MeshVertexonsurfaceEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	PrognosticHydrostaticAdjustmentEnum,
	PrognosticPenaltyFactorEnum,
	PrognosticSpcthicknessEnum,
	PrognosticStabilizationEnum,
	PrognosticVertexPairingEnum,
	QmuIsdakotaEnum,
	QmuMassFluxSegmentsEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsResultsOnVerticesEnum,
	SettingsWaitonlockEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	SurfaceforcingsAblationRateEnum,
	SurfaceforcingsAccumulationRateEnum,
	SurfaceforcingsMassBalanceEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThicknessEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TransientIsdiagnosticEnum,
	TransientIsgroundinglineEnum,
	TransientIsprognosticEnum,
	TransientIsthermalEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{1 */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AdjointSolutionEnum,
	AnalysisCounterEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	BedSlopeAnalysisEnum,
	BedSlopeSolutionEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	DiagnosticSolutionEnum,
	DiagnosticVertAnalysisEnum,
	EnthalpyAnalysisEnum,
	EnthalpySolutionEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	NoneAnalysisEnum,
	PrognosticAnalysisEnum,
	PrognosticSolutionEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	NoneApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Datasets {{{1*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{1*/
	BoolInputEnum,
	BoolParamEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DofIndexingEnum,
	DoubleInputEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementResultEnum,
	ExternalResultEnum,
	FileParamEnum,
	HookEnum,
	IcefrontEnum,
	InputEnum,
	IntInputEnum,
	IntParamEnum,
	IntVecParamEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	MaticeEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	ParamEnum,
	PattynIceFrontEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaVertexInputEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	RiftfrontEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StokesIceFrontEnum,
	StringArrayParamEnum,
	StringParamEnum,
	TriaEnum,
	TriaVertexInputEnum,
	VertexEnum,
	/*}}}*/
	/*Fill {{{1*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{1*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConstantEnum,
	ConvergedEnum,
	ExtToIuEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GroundinglineMeltingRateEnum,
	InternalEnum,
	IuToExtEnum,
	MassFluxEnum,
	MaxPenetrationEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	NumberNodeToElementConnectivityEnum,
	PressureEnum,
	PressurePicardEnum,
	QmuPressureEnum,
	QmuVxEnum,
	QmuVyEnum,
	QmuVzEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureOldEnum,
	TemperaturePicardEnum,
	ThicknessAbsMisfitEnum,
	TypeEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzPicardEnum,
	VzStokesEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	OutputfilenameEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	IceVolumeEnum,
	/*}}}*/
	/*Element Interpolations{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	/*}}}*/
	/*Results{{{1*/
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleElementResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	DoubleVecExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchNodesEnum,
	PatchVerticesEnum,
	PentaVertexElementResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	TimeEnum,
	TriaVertexElementResultEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Responses{{{1*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{1*/
	AgressiveMigrationEnum,
	NoneEnum,
	SoftMigrationEnum,
	/*}}}*/
	/*Solver{{{1*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{1*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputFilePointerEnum,
	PetscOptionsAnalysesEnum,
	PetscOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{1*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Options{{{1*/
	OptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionStructEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{1*/
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	MaximumNumberOfEnums
};

/*Functions on enums: */
char *EnumToModelField(int  en);

#endif
