/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

#include "../modules/EnumToStringx/EnumToStringx.h"
#include "../modules/StringToEnumx/StringToEnumx.h"

enum definitions{
	/*Model fields {{{1*/
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	SurfaceforcingsAccumulationRateEnum,
	SurfaceforcingsAblationRateEnum,
	SurfaceforcingsMassBalanceEnum,
	BasalforcingsMeltingRateEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsGeothermalfluxEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	RiftsRiftstructEnum,
	RiftsNumriftsEnum,
	HydrologySpcwatercolumnEnum,
	HydrologyKnEnum,
	HydrologyNEnum,
	HydrologyPEnum,
	HydrologyQEnum,
	HydrologyCREnum,
	HydrologyStabilizationEnum,
	SettingsLowmemEnum,
	SettingsIoGatherEnum,
	SettingsResultsOnVerticesEnum,
	SettingsOutputFrequencyEnum,
	SettingsWaitonlockEnum,
	ThermalSpctemperatureEnum,
	ThermalPenaltyThresholdEnum,
	ThermalPenaltyLockEnum,
	ThermalMaxiterEnum,
	ThermalStabilizationEnum,
	ThermalPenaltyFactorEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	TimesteppingTimeStepEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingCflCoefficientEnum,
	PrognosticSpcthicknessEnum,
	PrognosticHydrostaticAdjustmentEnum,
	PrognosticStabilizationEnum,
	PrognosticVertexPairingEnum,
	PrognosticPenaltyFactorEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyNEnum,
	MaterialsRheologyLawEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoWaterEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsBetaEnum,
	MaterialsThermalconductivityEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsMeltingpointEnum,
	MaskElementongroundediceEnum,
	MaskElementonfloatingiceEnum,
	MaskElementonwaterEnum,
	MaskVertexongroundediceEnum,
	MaskVertexonfloatingiceEnum,
	MaskVertexonwaterEnum,
	QmuIsdakotaEnum,
	QmuMassFluxSegmentsEnum,
	QmuPartitionEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessThickeningRateEnum,
	BalancethicknessStabilizationEnum,
	FlowequationIshutterEnum,
	FlowequationIsmacayealpattynEnum,
	FlowequationIsstokesEnum,
	FlowequationElementEquationEnum,
	FlowequationVertexEquationEnum,
	FlowequationBorderstokesEnum,
	FlowequationBorderpattynEnum,
	FlowequationBordermacayealEnum,
	SteadystateRequestedOutputsEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateMaxiterEnum,
	TransientIsprognosticEnum,
	TransientIsdiagnosticEnum,
	TransientIsthermalEnum,
	TransientIsgroundinglineEnum,
	TransientRequestedOutputsEnum,
	TransientNumRequestedOutputsEnum,
	InversionIscontrolEnum,
	InversionControlParametersEnum,
	InversionCostFunctionsEnum,
	InversionCostFunctionEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionNstepsEnum,
	InversionMaxiterPerStepEnum,
	InversionGradientScalingEnum,
	InversionGradientOnlyEnum,
	InversionCostFunctionThresholdEnum,
	InversionMaxParametersEnum,
	InversionMinParametersEnum,
	InversionStepThresholdEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	InversionVelObsEnum,
	InversionThicknessObsEnum,
	DiagnosticSpcvxEnum,
	DiagnosticSpcvyEnum,
	DiagnosticSpcvzEnum,
	DiagnosticStokesreconditioningEnum,
	DiagnosticIcefrontEnum,
	DiagnosticReferentialEnum,
	DiagnosticVertexPairingEnum,
	DiagnosticPenaltyFactorEnum,
	DiagnosticAbstolEnum,
	DiagnosticReltolEnum,
	DiagnosticRestolEnum,
	DiagnosticMaxiterEnum,
	DiagnosticShelfDampeningEnum,
	DiagnosticRiftPenaltyLockEnum,
	DiagnosticRiftPenaltyThresholdEnum,
	DiagnosticRequestedOutputsEnum,
	DiagnosticNumRequestedOutputsEnum,
	DiagnosticViscosityOvershootEnum,
	GeometryHydrostaticRatioEnum,
	ThicknessEnum,
	BedEnum,
	BathymetryEnum,
	SurfaceEnum,
	AutodiffIsautodiffEnum, 
	AutodiffForwardEnum,
	AutodiffReverseEnum,
	MeshAverageVertexConnectivityEnum,
	MeshDimensionEnum,
	MeshNumberofelementsEnum,
	MeshNumberofverticesEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofedgesEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshElementconnectivityEnum,
	MeshLowerelementsEnum,
	MeshUpperelementsEnum,
	MeshElementonbedEnum,
	MeshElementonsurfaceEnum,
	MeshVertexonbedEnum,
	MeshVertexonsurfaceEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshEdgesEnum,
	MeshYEnum,
	MeshZEnum,
	MeshXEnum,
	/*}}}*/
	/*Datasets {{{1*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticSolutionEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	//control
	AdjointSolutionEnum,
	AdjointHorizAnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	//thermal
	ThermalSolutionEnum,
	ThermalAnalysisEnum,
	//hydro
	HydrologySolutionEnum,
	HydrologyAnalysisEnum,
	//transient
	TransientSolutionEnum,
	//slope
	BedSlopeSolutionEnum,
	BedSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	BalancethicknessSolutionEnum,
	BalancethicknessAnalysisEnum,
	PrognosticSolutionEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//steadystate
	SteadystateSolutionEnum,
	//flaim
	FlaimSolutionEnum,
	FlaimAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	NoneApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Objects {{{1*/
	HookEnum,
	SegmentEnum,
	/*Elements: */
	ElementEnum,
	DofIndexingEnum,
	PentaEnum,
	TriaEnum,
	/*Nodes: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	RiftfrontEnum,
	SegmentRiftfrontEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	PattynIceFrontEnum,
	StokesIceFrontEnum,
	/*Materials: */
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	TriaVertexInputEnum,
	ControlInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleMatArrayParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	FileParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ElementResultEnum,
	ExternalResultEnum,
	/*Spc: */
	SpcStaticEnum,
	SpcTransientEnum,
	/*}}}*/
	/*Geography {{{1*/
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Rift state {{{1*/
	FreeEnum,
	OpenEnum,
	ClosedEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AdjointpEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConstantEnum,
	ConvergedEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	InternalEnum,
	IuToExtEnum,
	ExtToIuEnum,
	MassFluxEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceAverageVelMisfitEnum,
	MaxPenetrationEnum,
	MeltingOffsetEnum,
	GroundinglineMeltingRateEnum,
	MisfitEnum,
	NumberNodeToElementConnectivityEnum,
	PressureEnum,
	PressurePicardEnum,
	VelocityEnum,
	QmuPressureEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAreaEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	TemperatureOldEnum,
	TypeEnum,
	VelEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	QmuVyEnum,
	VzEnum,
	VzPicardEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzStokesEnum,
	QmuVzEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	/*}}}*/
	/*Results{{{1*/
	DoubleElementResultEnum,
	TriaVertexElementResultEnum,
	PentaVertexElementResultEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleVecExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchVerticesEnum,
	PatchNodesEnum,
	TimeEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Responses{{{1*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{1*/
	NoneEnum,
	AgressiveMigrationEnum,
	SoftMigrationEnum,
	/*}}}*/

	/*Solver{{{1*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{1*/
	IntersectEnum,
	ColinearEnum,
	SeparateEnum,
	AdjointEnum,
	GradientEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	OldGradientEnum,
	ControlSteadyEnum,

	OutputFilePointerEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	IndexedEnum,
	RegularEnum,
	IndexEnum,
	ScaledEnum,
	NodalEnum,
	VerboseEnum,
	PetscOptionsStringsEnum,
	PetscOptionsAnalysesEnum,
	GsetEnum,
	FsetEnum,
	SsetEnum,
	GroundinglineMigrationEnum,
	/*}}}*/
	/*Interpolation {{{1*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Options{{{1*/
	OptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionStructEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{1*/
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpySolutionEnum,
	EnthalpyAnalysisEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	DatasetInputEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	OutputfilenameEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	SpcDynamicEnum,
	IceVolumeEnum,
	MaximumNumberOfEnums
};

/*Functions on enums: */
char *EnumToModelField(int  en);

#endif
