/*!\file: elements.h
 * \brief prototypes for elements.h
 */ 

#ifndef _SHARED_ELEMENTS_H_
#define  _SHARED_ELEMENTS_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"
class ElementMatrix;
class ElementVector;

double Paterson(double temperature);
double Arrhenius(double temperature,double depth,double n);
int    GetVerticesCoordinates(double* xyz,  Node** nodes, int numvertices);
int    GetNumberOfDofs( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*   GetLocalDofList( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*   GetGlobalDofList(Node** nodes,int numnodes,int setenum,int approximation_enum);
void   CoordinateSystemTransform(double** ptransform,Node** nodes,int numnodes,int dofspernode);
#ifdef _HAVE_DIAGNOSTIC_
void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int dofspernode);
void   TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int dofspernode);
void   TransformSolutionCoord(double* solution,Node** nodes,int numnodes,int dofspernode);
#endif

inline void printarray(double* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %12.7g ",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}
inline void printarray(int* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %6i",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}

#endif //ifndef _SHARED_ELEMENTS_H_
