function plot_referential(md,options,width,i,data);
%PLOT_PRESSURELOAD - plot segment on neumann BC
%
%   Usage:
%      plot_referential(md,options,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%process mesh and data
[x y z elements is2d isplanet]=processmesh(md,[],options);
referential=md.diagnostic.referential;

Xhat=md.diagnostic.referential(:,1:3);
pos=find(sum(isnan(Xhat),2));
Xhat(pos,:)=repmat([1 0 0],size(pos,1),1);
Xhatnorm=sqrt(Xhat(:,1).^2+Xhat(:,2).^2+Xhat(:,3).^2);
Xhat=Xhat./[Xhatnorm Xhatnorm Xhatnorm];

Zhat=md.diagnostic.referential(:,4:6);
pos=find(sum(isnan(Zhat),2));
Zhat(pos,:)=repmat([0 0 1],size(pos,1),1);
Zhatnorm=sqrt(Zhat(:,1).^2+Zhat(:,2).^2+Zhat(:,3).^2);
Zhat=Zhat./[Zhatnorm Zhatnorm Zhatnorm];

Yhat=cross(Zhat,Xhat);

if (md.mesh.dimension==2),

	%plot mesh
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	h1=patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	hold on;

	xstart=x;
	ystart=y;
	zstart=z;
	edgex=max(md.mesh.x(elements),[],2)-min(md.mesh.x(elements),[],2);
	len=min(edgex)/1.5;
	%plot X axis
	xend=xstart+len*Xhat(:,1);
	yend=ystart+len*Xhat(:,2);
	hx=quiver(xstart,ystart,xend-xstart,yend-ystart,'Color','blue','ShowArrowHead','on','AutoScale','off');
	%plot Y axis
	xend=xstart+len*Yhat(:,1);
	yend=ystart+len*Yhat(:,2);
	hy=quiver(xstart,ystart,xend-xstart,yend-ystart,'Color','red','ShowArrowHead','on','AutoScale','off');
else
	error('3d not supported yet')
end

%legend (disable warnings)
legend([hx,hy],'local X direction','local Y direction')

%apply options
options=addfielddefault(options,'title','Diagnostic referential');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
