/*!\file:  TransformStiffnessMatrixCoord.cpp
 * \brief transform stiffness matrix coordinate system
 */ 
#include "./elements.h"

void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int dofspernode){

	int     i,j;
	double *transform = NULL;
	double *values    = NULL;

	/*Copy current stiffness matrix*/
	values=(double*)xmalloc(Ke->nrows*Ke->ncols*sizeof(double));
	for(i=0;i<Ke->nrows;i++) for(j=0;j<Ke->ncols;j++) values[i*Ke->ncols+j]=Ke->values[i*Ke->ncols+j];

	/*Get Coordinate Systems transform matrix*/
	CoordinateSystemTransform(&transform,nodes,numnodes,dofspernode);

	/*Transform matrix: R^T*Ke*R */
	TripleMultiply(transform,numnodes*dofspernode,numnodes*dofspernode,1,
				values,Ke->nrows,Ke->ncols,0,
				transform,numnodes*dofspernode,numnodes*dofspernode,0,
				&Ke->values[0],0);

	/*Free Matrix*/
	xfree((void**)&transform);
	xfree((void**)&values);
}
