/*!\file:  TransformSolutionCoord.cpp
 * \brief transform solution vector coordinate system
 */ 
#include "./elements.h"

void TransformSolutionCoord(double* solution,Node** nodes,int numnodes,int dofspernode){

	int     i,j;
	double *transform = NULL;
	double *values    = NULL;

	/*Copy current solution vector*/
	values=(double*)xmalloc(numnodes*dofspernode*sizeof(double));
	for(i=0;i<numnodes*dofspernode;i++) values[i]=solution[i];

	/*Get Coordinate Systems transform matrix*/
	CoordinateSystemTransform(&transform,nodes,numnodes,dofspernode);

	/*Transform matrix: R*U */
	MatrixMultiply(transform,numnodes*dofspernode,numnodes*dofspernode,0,
				values,numnodes*dofspernode,1,0,
				&solution[0],0);

	/*Free Matrix*/
	xfree((void**)&transform);
	xfree((void**)&values);
}
