/*!\file:  TransformLoadVectorCoord.cpp
 * \brief transform load vector coordinate system
 */ 
#include "./elements.h"

void TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int dofspernode){

	int     i,j;
	double *transform = NULL;
	double *values    = NULL;

	/*Copy current load vector*/
	values=(double*)xmalloc(pe->nrows*sizeof(double));
	for(i=0;i<pe->nrows;i++) values[i]=pe->values[i];

	/*Get Coordinate Systems transform matrix*/
	CoordinateSystemTransform(&transform,nodes,numnodes,dofspernode);

	/*Transform matrix: R^T*pe */
	MatrixMultiply(transform,numnodes*dofspernode,numnodes*dofspernode,1,
				values,pe->nrows,1,0,
				&pe->values[0],0);

	/*Free Matrix*/
	xfree((void**)&transform);
	xfree((void**)&values);
}
