/*\file ConfigureObjects.c
 *\brief: configure objects (elements, loads for example), that need linking with nodes
 */

#include "./ConfigureObjects.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* loads=NULL;
	DataSet* nodes=NULL;
	DataSet* materials=NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ConfigureObjectsUsage);
	
	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTSIN,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADSIN,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);

	/*!Configure objects:*/
	ConfigureObjectsx(elements, loads, nodes, materials);

	/*write output datasets: */
	WriteData(ELEMENTS,elements,0,0,"DataSet",NULL);
	WriteData(LOADS,loads,0,0,"DataSet",NULL);
	WriteData(NODESOUT,nodes,0,0,"DataSet",NULL);

	/*Free ressources: */
	delete elements;
	delete loads;
	delete nodes;
	delete materials;

	/*end module: */
	MODULEEND();
}

void ConfigureObjectsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,loads, nodes] = %s(elements,loads,nodes, materials);\n",__FUNCT__);
	_printf_("\n");
}
