function md=control(md)
%CONTROL - launch control solution sequence
%
%   Usage:
%      md=control(md)
%

	%timing
	t1=clock;
	
	%Build all models requested for control simulation
	models.analysis_type='control'; %needed for processresults

	displaystring(md.debug,'%s',['reading control horiz model data']);
	md.analysis_type='control'; md.sub_analysis_type='horiz'; models.dh=CreateFemModel(md);

	displaystring(md.debug,'\n%s',['reading control vert model data']);
	md.analysis_type='control'; md.sub_analysis_type='vert'; models.dv=CreateFemModel(md);

	displaystring(md.debug,'\n%s',['reading control stokes model data']);
	md.analysis_type='control'; md.sub_analysis_type='stokes'; models.ds=CreateFemModel(md);

	displaystring(md.debug,'\n%s',['reading control hutter model data']);
	md.analysis_type='control'; md.sub_analysis_type='hutter'; models.dhu=CreateFemModel(md);

	displaystring(md.debug,'\n%s',['reading surface and bed slope computation model data']);
	md.analysis_type='slope_compute'; md.sub_analysis_type=''; models.sl=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.dh.parameters.u_g,'doublevec',3,models.dh.parameters.numberofnodes);

	%compute solution
	if ~models.dh.parameters.qmu_analysis,
		%launch core of control solution.
		results=control_core(models,inputs);

		%process results
		if ~isstruct(md.results), md.results=struct(); end
		md.results.control=processresults(models,results);
	else
		%launch dakota driver for control core solution
		Qmu(models,inputs,models.dh.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
