/*!\file:  GroundinglineMigrationx.h
 * \brief header file for Grounding Line Migration
 */ 

#ifndef _GROUNDINGLINEMIGRATIONX_H
#define _GROUNDINGLINEMIGRATIONX_H

class Elements;
class Vertices;
class Nodes;
class Parameters;

/* local prototypes: */
void       GroundinglineMigrationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters);

Vec        CreateNodesOnFloatingIce(Nodes* nodes,int configuration_type);
double*    PotentialSheetUngrounding(Elements* elements,Vertices* vertices,Parameters* parameters);
double*    PropagateFloatingiceToGrounded(Elements* elements,Nodes* nodes,Vertices* vertices,Parameters* parameters,double* vertices_potentially_ungrounding);
#endif  /* _GROUNDINGLINEMIGRATIONX_H */
