/*!\file:  GetGlobalDofList.cpp
 * \brief create transform matrix for different coordinate systems
 */ 
#include "./elements.h"

void CoordinateSystemTransform(double** ptransform,Node** nodes,int numnodes,int dimension){

	int     i;
	double *transform         = NULL;
	double *values            = NULL;
	double  coord_system[3][3];

	/*Some checks*/
	_assert_(numnodes && nodes);
	if(dimension!=2 && dimension!=3) _error_("only 2d and 3d coordinate systems are supported");

	/*Allocate and initialize transform matrix*/
	transform=(double*)xmalloc(numnodes*dimension*numnodes*dimension*sizeof(double));
	for(i=0;i<numnodes*dimension*numnodes*dimension;i++) transform[i]=0.0;

	/*Create transform matrix for all nodes (x,y for 2d and x,y,z for 3d). It is a block matrix
	 *for 3 nodes:

	 *     | T1 0  0 |
	 * Q = | 0  T2 0 |
	 *     | 0  0  T3|
	 *
	 * Where T1 is the transform matrix for node 1. It is a simple copy of the coordinate system
	 * associated to this node*/
	for(i=0;i<numnodes;i++){
		nodes[i]->GetCoordinateSystem(&coord_system[0][0]);
		if(dimension==2){
			transform[(dimension*numnodes)*(i*dimension+0) + i*dimension+0] = coord_system[0][0];
			transform[(dimension*numnodes)*(i*dimension+0) + i*dimension+1] = coord_system[0][1];
			transform[(dimension*numnodes)*(i*dimension+1) + i*dimension+0] = coord_system[1][0];
			transform[(dimension*numnodes)*(i*dimension+1) + i*dimension+1] = coord_system[1][1];
		}
		else if(dimension==3){
			transform[(dimension*numnodes)*(i*dimension+0) + i*dimension+0] = coord_system[0][0];
			transform[(dimension*numnodes)*(i*dimension+0) + i*dimension+1] = coord_system[0][1];
			transform[(dimension*numnodes)*(i*dimension+0) + i*dimension+2] = coord_system[0][2];
			transform[(dimension*numnodes)*(i*dimension+1) + i*dimension+0] = coord_system[1][0];
			transform[(dimension*numnodes)*(i*dimension+1) + i*dimension+1] = coord_system[1][1];
			transform[(dimension*numnodes)*(i*dimension+1) + i*dimension+2] = coord_system[1][2];
			transform[(dimension*numnodes)*(i*dimension+2) + i*dimension+0] = coord_system[2][0];
			transform[(dimension*numnodes)*(i*dimension+2) + i*dimension+1] = coord_system[2][1];
			transform[(dimension*numnodes)*(i*dimension+2) + i*dimension+2] = coord_system[2][2];
		}
	}

	/*Assign output pointer*/
	*ptransform=transform;
}
