/*!\file:  GroundinglineMigrationxLocal.h
 * \brief local header file for Grounding Line Migration
 */ 

#ifndef _GROUNDINGLINEMIGRATIONXLOCAL_H
#define _GROUNDINGLINEMIGRATIONXLOCAL_H

class Elements;
class Vertices;
class Nodes;
class Parameters;

/* local prototypes: */
bool*      CreateElementOnGroundingline(Elements* elements,double* element_on_iceshelf);
double*    CreateElementOnIceShelf(Elements* elements);
double*    CreateElementTouchingIceShelf(Elements* elements,double* nodes_on_iceshelf);
Vec        CreateNodesOnIceShelf(Nodes* nodes,Vertices* vertices,int analysis_type);
double*    PotentialSheetUngrounding(Elements* elements,Vertices* vertices,Parameters* parameters);
double*    PropagateShelfIntoConnexIceSheet(Elements* elements,Nodes* nodes,Vertices* vertices,Parameters* parameters,double* vertices_potentially_ungrounding);

int        UpdateShelfStatus(Elements* elements,Nodes* nodes,Parameters* parameters,double* element_touching_iceshelf);
#endif  /* _GROUNDINGLINEMIGRATIONXLOCAL_H */
