/*!\file GroundinglineMigrationx
 * \brief: migration grounding line position.
 */

#include "./GroundinglineMigrationx.h"
#include "./GroundinglineMigrationxLocal.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"

void GroundinglineMigrationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

	int      i, migration_style;
	double*  vertices_potentially_ungrounding = NULL;
	double*  sheet_ungrounding                = NULL;
	Element* element                          = NULL;
	
	_printf_(VerboseModule(),"   Migrating grounding line\n");
	
	/*retrieve parameters: */
	parameters->FindParam(&migration_style,GroundinglineMigrationEnum);
	if(migration_style==NoneEnum) return;
	if(migration_style!=AgressiveMigrationEnum && migration_style!=SoftMigrationEnum) _error_("%s not supported yet!",EnumToStringx(migration_style));

	if(migration_style==SoftMigrationEnum){
		/*Create flag for nodes above the hydrostatic equilibrium: */
		vertices_potentially_ungrounding=PotentialSheetUngrounding(elements,vertices,parameters);

		/*propagate ice shelf into connex areas of the ice sheet that potentially want to unground: */
		sheet_ungrounding=PropagateShelfIntoConnexIceSheet(elements,nodes,parameters,vertices_potentially_ungrounding);
	}

	/*Migrate grounding line : */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->Migration(sheet_ungrounding);
	}

	/*Synchronise mask: */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ShelfSync();
	}

	/*free ressouces: */
	xfree((void**)&vertices_potentially_ungrounding);
	xfree((void**)&sheet_ungrounding);
}
