/*!\file:  GroundinglineMigrationxLocal.h
 * \brief local header file for Grounding Line Migration
 */ 

#ifndef _GROUNDINGLINEMIGRATIONXLOCAL_H
#define _GROUNDINGLINEMIGRATIONXLOCAL_H

class Elements;
class Vertices;
class Nodes;
class Parameters;

/* local prototypes: */
double*    PotentialSheetUngrounding(Elements* elements,Vertices* vertices,Parameters* parameters);
double*    PropagateShelfIntoConnexIceSheet(Elements* elements,Nodes* nodes,Parameters* parameters,double* vertices_potentially_ungrounding);
bool*      CreateElementOnGroundingline(Elements* elements,double* element_on_iceshelf);
double*    CreateElementOnIceShelf(Elements* elements);
double*    CreateElementTouchingIceShelf(Elements* elements,Vec vec_nodes_on_iceshelf);
int        UpdateShelfStatus(Elements* elements,Nodes* nodes,Parameters* parameters,double* element_touching_iceshelf);
Vec        CreateNodesOnIceShelf(Nodes* nodes,int analysis_type);
#endif  /* _GROUNDINGLINEMIGRATIONXLOCAL_H */
