tolerance=1e-13;

md=model;
md.cluster=generic('name',oshostname(),'np',3);
md.miscellaneous.name='validation';

%launch solution directly: 
!source validation.queue

md=loadresultsfromdisk(md,'validation.outbin');

s=load('Archive/archive.mat'); h0=s.Archive110_field1;
h=md.results.PrognosticSolution.Thickness;

error_diff=full(max(abs(h-h0))/(max(abs(h0))+eps));

if (error_diff>tolerance);
	disp(sprintf(['\n\n\nERROR   difference: %-7.2g > %7.2g \n\n\n'],error_diff,tolerance));
else
	disp(sprintf(['\n\n\nSUCCESS difference: %-7.2g < %7.2g \n\n\n'],error_diff,tolerance));
end

