function node = node(varargin)
%NODE - constructor for node object
%
%   Usage:
%      node = node(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	node.id=NaN;
	node.x=NaN;
	node.y=NaN;
	node.z=NaN;
	node.s=NaN;
	node.doflist=zeros(6,1); %6 degrees of freedom available per node.
	node.gridset='';
	node.onbed=NaN;
	node.border=0; %border flag: 1 implies this grid belongs to the metis partition borders (See ModelProcessor.m for more details)
	node.uppergrid=NaN;
	node.lowergrid=NaN;
	node=class(node,'node');
				
case 1
	%If single argument of class node, we have a copy constructor. 
	if (isa(varargin{1},'node'))
		node = varargin{1};
	else
		error('node constructor error message: copy constructor called on a non ''node'' class object');
	end 
otherwise
	error('node constructor error message: 0 of 1 argument only in input.');
end
