tolerance=1e-13;

md=setmesh(model,'Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'Par/SquareShelfConstrained.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);

md.autodiff.analysis=true;
md.autodiff.forward=true;
md.verbose=verbose('solution',true);

md=solve(md,PrognosticSolutionEnum);

s=load('Archive/archive.mat'); h0=s.Archive110_field1;
h=PatchToVec(md.results.PrognosticSolution.Thickness);

error_diff=full(max(abs(h-h0))/(max(abs(h0))+eps));

if (error_diff>tolerance);
	disp(sprintf(['\n\n\nERROR   difference: %-7.2g > %7.2g \n\n\n'],error_diff,tolerance));
else
	disp(sprintf(['\n\n\nSUCCESS difference: %-7.2g < %7.2g \n\n\n'],error_diff,tolerance));
end

