/*!\file GroundinglineMigrationx
 * \brief: migration grounding line position.
 */

#include "./GroundinglineMigrationx.h"
#include "./GroundinglineMigrationxLocal.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"

void GroundinglineMigrationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

	int i, migration_style;
	Element* element=NULL;
	
	_printf_(VerboseModule(),"   Migrating grounding line\n");
	
	/*retrieve parameters: */
	parameters->FindParam(&migration_style,GroundinglineMigrationEnum);

	/*call different migration modules, according to user wishes: */
	if(migration_style==AgressiveMigrationEnum){
		/*Migrate grounding line : */
		for(i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->AgressiveMigration();
		}

		/*Synchronise mask: */
		for(i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->ShelfSync();
		}
	}
	else if(migration_style==SoftMigrationEnum){

		/*Create flag for nodes above the hydrostatic equilibrium: */
		double* potential_sheet_ungrounding=PotentialSheetUngrounding(elements,nodes,parameters);

		/*propagate ice shelf into connex areas of the ice sheet that potentially want to unground: */
		double* sheet_ungrounding=PropagateShelfIntoConnexIceSheet(elements,nodes,parameters,potential_sheet_ungrounding);

		/*Now, use the sheet_ungrounding flags to unground the ice sheet (at the same time, take care of grounding elements of the ice shelf 
		 * that want to: */
		for(i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->SoftMigration(sheet_ungrounding);
		}

		/*Synchronise mask*/
		for(i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			element->ShelfSync();
		}

		/*free ressouces: */
		xfree((void**)&potential_sheet_ungrounding);
		xfree((void**)&sheet_ungrounding);
	}
	else if(migration_style==NoneEnum) _printf_(true,"%s\n","NoneEnum supplied for migration style, doing nothing!");
	else _error_("%s not supported yet!",EnumToStringx(migration_style));
}
