/*!\file GroundinglineMigrationx
 * \brief: migration grounding line position.
 */

#include "./GroundinglineMigrationx.h"
#include "./GroundinglineMigrationxLocal.h"

#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../include/include.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"

void GroundinglineMigrationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

	int migration_style;
	
	_printf_(VerboseModule(),"   Migrating grounding line\n");
	
	/*retrieve parameters: */
	parameters->FindParam(&migration_style,GroundinglineMigrationEnum);

	/*call different migration modules, according to user wishes: */
	if(migration_style==AgressiveMigrationEnum) AgressiveMigration(elements,nodes, vertices,loads,materials, parameters);
	else if(migration_style==SoftMigrationEnum) SoftMigration(elements,nodes, vertices,loads,materials, parameters);
	else if(migration_style==NoneEnum) _printf_(true,"%s\n","NoneEnum supplied for migration style, doing nothing!");
	else _error_("%s not supported yet!",EnumToStringx(migration_style));
}
