/*\file GroundinglineMigration.c
*\brief: update elements properties using an input  vector
*/

#include "./GroundinglineMigration.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements*   elements          = NULL;
	Nodes      *nodes             = NULL;
	Vertices    *vertices          = NULL;
	Loads     *loads             = NULL;
	Materials   *materials         = NULL;
	Parameters *parameters        = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GroundinglineMigrationUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTSIN);
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((DataSet**)&vertices,VERTICESIN);
	FetchMatlabData((DataSet**)&loads,LOADSIN);
	FetchMatlabData((DataSet**)&materials,MATERIALSIN);
	FetchMatlabData(&parameters,PARAMETERSIN);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*call "x" code layer*/
	GroundinglineMigrationx(elements,nodes,vertices,loads, materials,parameters);

	/*write output datasets: */
	WriteMatlabData(ELEMENTS,elements);
	WriteMatlabData(NODES,nodes);
	WriteMatlabData(VERTICES,vertices);
	WriteMatlabData(LOADS,loads);
	WriteMatlabData(MATERIALS,materials);
	WriteMatlabData(PARAMETERS,parameters);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void GroundinglineMigrationUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
