/*!\file:  GroundingLineMigrationxLocal.h
 * \brief local header file for Grounding Line Migration
 */ 

#ifndef _GROUNDINGLINEMIGRATIONXLOCAL_H
#define _GROUNDINGLINEMIGRATIONXLOCAL_H

class Elements;
class Nodes;
class Parameters;

/* local prototypes: */
void       AgressiveMigration(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters);
void       SoftMigration(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters);
double*    PotentialSheetUngrounding(Elements* elements,Nodes* nodes,Parameters* parameters);
double*    PropagateShelfIntoConnexIceSheet(Elements* elements,Nodes* nodes,Parameters* parameters,double* potential_sheet_ungrounding);
bool*      CreateElementOnGroundingLine(Elements* elements,double* element_on_iceshelf);
double*    CreateElementOnIceShelf(Elements* elements);
double*    CreateElementTouchingIceShelf(Elements* elements,Vec vec_nodes_on_iceshelf);
int        UpdateShelfStatus(Elements* elements,Nodes* nodes,Parameters* parameters,double* element_touching_iceshelf);
Vec        CreateNodesOnIceShelf(Nodes* nodes,int analysis_type);
#endif  /* _GROUNDINGLINEMIGRATIONXLOCAL_H */
