/*!\file Shp2Kmlx
 * \brief shp to kml conversion routines.
 */

#include "./Shp2Kmlx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

int Shp2Kmlx(char* filshp,char* filkml,
			 int sgn,
			 bool holes){

	#ifdef _HAVE_SHAPELIB_ //only works if Shapelib library has been compiled in.
	
	double  cm,sp;

	if (sgn)
		Xy2lldef(&cm,&sp,sgn);

	return(Shp2Kmlx(filshp,filkml,
					sgn,cm,sp,
					holes));

	#endif //ifdef _HAVE_SHAPELIB_
}

int Shp2Kmlx(char* filshp,char* filkml,
			 int sgn,double cm,double sp,
			 bool holes){

	#ifdef _HAVE_SHAPELIB_ //only works if Shapelib library has been compiled in.
	
	int     i,j,k,iret=0;
	int     lwidth=1;
	double  popac=0.50;
	int     nshap;
	int     *pstype=NULL,*pnpart=NULL,**ppstrt=NULL,**pptype=NULL,*pnvert=NULL;
	double  **pshapx=NULL,**pshapy=NULL,**pshapz=NULL,**pshapm=NULL;
	bool    *closed=NULL;
	double  *lat=NULL,*lon=NULL;

	SHPHandle   hSHP;
	int     nShapeType, nEntities, iPart, bValidate = 0,nInvalidCount=0;
	const char  *pszPlus;
	double  adfMinBound[4], adfMaxBound[4];

	char    indent[81]="";
	KML_File*             kfile =NULL;
	KML_Document*         kdoc  =NULL;
	KML_Style*            kstyle=NULL;
	KML_LineStyle*        klsty =NULL;
	KML_PolyStyle*        kpsty =NULL;
	KML_Folder*           kfold =NULL;
	KML_Placemark*        kplace=NULL;
	KML_MultiGeometry*    kmulti=NULL;
	KML_Polygon*          kpoly =NULL;
	KML_LinearRing*       kring =NULL;
	KML_LineString*       kline =NULL;
	KML_Point*            kpoint=NULL;

	FILE*   fid=NULL;

	clock_t clock0,clock1;
	time_t  time0, time1;

	clock0=clock();
	time0 =time(NULL);
	_printf_(true,"\nShp2Kmlx Module -- %s",ctime(&time0));

/*  note that much of the following code is taken from shpdump.c in shapelib.  */

/*  open shp/shx files  */

	hSHP = SHPOpen( filshp, "rb" );
	if (!hSHP) _error_("Error opening shp/shx files.");

/*  read header and print out file bounds  */

	SHPGetInfo( hSHP, &nEntities, &nShapeType, adfMinBound, adfMaxBound );

	printf( "Shapefile Type: %s   # of Shapes: %d\n\n",
			SHPTypeName( nShapeType ), nEntities );

	printf( "File Bounds: (%12.3f,%12.3f,%g,%g)\n"
			"         to  (%12.3f,%12.3f,%g,%g)\n",
			adfMinBound[0],
			adfMinBound[1],
			adfMinBound[2],
			adfMinBound[3],
			adfMaxBound[0],
			adfMaxBound[1],
			adfMaxBound[2],
			adfMaxBound[3] );

	nshap=nEntities;
	pstype=(int *) xmalloc(nshap*sizeof(int));
	pnpart=(int *) xmalloc(nshap*sizeof(int));
	ppstrt=(int **) xmalloc(nshap*sizeof(int *));
	pptype=(int **) xmalloc(nshap*sizeof(int *));
	pnvert=(int *) xmalloc(nshap*sizeof(int));
	pshapx=(double **) xmalloc(nshap*sizeof(double *));
	pshapy=(double **) xmalloc(nshap*sizeof(double *));
	pshapz=(double **) xmalloc(nshap*sizeof(double *));
	pshapm=(double **) xmalloc(nshap*sizeof(double *));

/*  loop over the list of shapes  */

	for( i = 0; i < nEntities; i++ )
	{
//	int     j;
		SHPObject   *psShape;

	psShape = SHPReadObject( hSHP, i );

	printf( "\nShape:%d (%s)  nVertices=%d, nParts=%d\n"
				"  Bounds:(%12.3f,%12.3f, %g, %g)\n"
				"      to (%12.3f,%12.3f, %g, %g)\n",
			i, SHPTypeName(psShape->nSHPType),
				psShape->nVertices, psShape->nParts,
				psShape->dfXMin, psShape->dfYMin,
				psShape->dfZMin, psShape->dfMMin,
				psShape->dfXMax, psShape->dfYMax,
				psShape->dfZMax, psShape->dfMMax );

	pstype[i]=psShape->nSHPType;
	pnpart[i]=psShape->nParts;
	if (pnpart[i]) {
		ppstrt[i]=(int *) xmalloc(pnpart[i]*sizeof(int));
		pptype[i]=(int *) xmalloc(pnpart[i]*sizeof(int));
	}
	else {
		ppstrt[i]=NULL;
		pptype[i]=NULL;
	}
	pnvert[i]=psShape->nVertices;
	if (pnvert[i]) {
		pshapx[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
		pshapy[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
		pshapz[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
		pshapm[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
	}
	else {
		pshapx[i]=NULL;
		pshapy[i]=NULL;
		pshapz[i]=NULL;
		pshapm[i]=NULL;
	}

	for( j = 0, iPart = 1; j < psShape->nVertices; j++ )
	{
			const char  *pszPartType = "";

			if( j == 0 && psShape->nParts > 0 )
			{
				pszPartType = SHPPartTypeName( psShape->panPartType[0] );
				ppstrt[i][0]=psShape->panPartStart[0];
				pptype[i][0]=psShape->panPartType[0];
			}

		if( iPart < psShape->nParts
				&& psShape->panPartStart[iPart] == j )
		{
				pszPartType = SHPPartTypeName( psShape->panPartType[iPart] );
				ppstrt[i][iPart]=psShape->panPartStart[iPart];
				pptype[i][iPart]=psShape->panPartType[iPart];
		iPart++;
		pszPlus = "+";
		}
		else
			pszPlus = " ";

//		printf("   %s (%12.3f,%12.3f, %g, %g) %s \n",
//				   pszPlus,
//				   psShape->padfX[j],
//				   psShape->padfY[j],
//				   psShape->padfZ[j],
//				   psShape->padfM[j],
//				   pszPartType );

		pshapx[i][j]=psShape->padfX[j];
		pshapy[i][j]=psShape->padfY[j];
		pshapz[i][j]=psShape->padfZ[j];
		pshapm[i][j]=psShape->padfM[j];
	}

		if( bValidate )
		{
			int nAltered = SHPRewindObject( hSHP, psShape );

			if( nAltered > 0 )
			{
				printf( "  %d rings wound in the wrong direction.\n",
						nAltered );
				nInvalidCount++;
			}
		}

		SHPDestroyObject( psShape );
	}

/*  close shp/shx files  */

	SHPClose( hSHP );

/*  read exp file  */

//	if (!DomainOutlineRead(&nshap,&pnvert,&pshapx,&pshapy,&closed,filshp,false))
//		_error_("Error reading exp file.");

/*  construct kml file  */

	kfile =new KML_File();
	kfile->AddAttrib("xmlns","http://www.opengis.net/kml/2.2");

/*  construct kml document  */

	kdoc  =new KML_Document();
	sprintf(kdoc->name      ,"Shp2Kmlx Module -- %s",ctime(&time0));
	kdoc->open      =1;

/*  construct style templates for defaults  */

	klsty =new KML_LineStyle();
	sprintf(klsty->color     ,"ff000000");
	sprintf(klsty->colormode ,"normal");
	klsty->width     =lwidth;
	kpsty =new KML_PolyStyle();
	sprintf(kpsty->color     ,"%02xffffff",(int)floor(popac*255+0.5));
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	kstyle->AddAttrib("id","BlackLineRandomPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	klsty =new KML_LineStyle();
	sprintf(klsty->color     ,"ff000000");
	sprintf(klsty->colormode ,"normal");
	klsty->width     ,lwidth;
	kpsty =new KML_PolyStyle();
	sprintf(kpsty->color     ,"00ffffff");
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	kstyle->AddAttrib("id","BlackLineEmptyPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	klsty =new KML_LineStyle();
	sprintf(klsty->color     ,"%02xffffff",(int)floor(popac*255+0.5));
	sprintf(klsty->colormode ,"random");
	klsty->width     =lwidth*2;
	kpsty =new KML_PolyStyle();
	sprintf(kpsty->color     ,"00ffffff");
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	kstyle->AddAttrib("id","RandomLineEmptyPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

/*  construct kml folder for shapes  */

	kfold =new KML_Folder();
	sprintf(kfold->name      ,"Shapefile: %s  Type: %s  nShapes: %d",
			filshp, SHPTypeName( nShapeType ), nEntities );
	kfold->open      =1;

/*  loop over the list of shapes  */

	for (i=0; i<nshap; i++) {

/*  null type  */

		if      (pstype[i] == SHPT_NULL) {
			;
		}

/*  point types  */

		else if (pstype[i] == SHPT_POINT ||
			  	 pstype[i] == SHPT_POINTZ ||
			 	 pstype[i] == SHPT_POINTM) {
			kplace=new KML_Placemark();

			sprintf(kplace->name      ,"Shape:%d (%s)  nVertices=%d, nParts=%d",
					i,SHPTypeName(pstype[i]),pnvert[i],pnpart[i]);
			kplace->visibility=true;
			sprintf(kplace->styleurl  ,"#RandomLineEmptyPoly");

			if (pnpart[i] > 0)
				_printf_(true,"Warning -- Shape %d of type \"%s\" should not have %d > 0 parts.\n",
						 i,SHPTypeName( pstype[i] ),pnpart[i]);
			if (pnvert[i] > 1)
				_printf_(true,"Warning -- Shape %d of type \"%s\" should not have %d > 1 vertices.\n",
						 i,SHPTypeName( pstype[i] ),pnvert[i]);

			kpoint=new KML_Point();

			lat=(double *) xmalloc(pnvert[i]*sizeof(double));
			lon=(double *) xmalloc(pnvert[i]*sizeof(double));
			if (sgn) {
				Xy2llx(lat,lon,pshapx[i],pshapy[i],pnvert[i],sgn,cm,sp);
			}
			else  {
				memcpy(lon,pshapx[i],pnvert[i]*sizeof(double));
				memcpy(lat,pshapy[i],pnvert[i]*sizeof(double));
			}

			kpoint->coords[0]=lon      [0];
			kpoint->coords[1]=lat      [0];
			kpoint->coords[2]=pshapz[i][0];

			xfree((void**)&lon);
			xfree((void**)&lat);

			(kplace->geometry  )->AddObject((Object*)kpoint);
			kpoint=NULL;
			(kfold ->feature   )->AddObject((Object*)kplace);
			kplace=NULL;
		}

/*  polyline types  */

		else if (pstype[i] == SHPT_ARC ||
				 pstype[i] == SHPT_ARCZ ||
				 pstype[i] == SHPT_ARCM) {
			kplace=new KML_Placemark();

			sprintf(kplace->name      ,"Shape:%d (%s)  nVertices=%d, nParts=%d",
					i,SHPTypeName(pstype[i]),pnvert[i],pnpart[i]);
			kplace->visibility=true;
			sprintf(kplace->styleurl  ,"#RandomLineEmptyPoly");

			kmulti=new KML_MultiGeometry();

			lat=(double *) xmalloc(pnvert[i]*sizeof(double));
			lon=(double *) xmalloc(pnvert[i]*sizeof(double));
			if (sgn) {
				Xy2llx(lat,lon,pshapx[i],pshapy[i],pnvert[i],sgn,cm,sp);
			}
			else  {
				memcpy(lon,pshapx[i],pnvert[i]*sizeof(double));
				memcpy(lat,pshapy[i],pnvert[i]*sizeof(double));
			}

			for (j=0; j<pnpart[i]; j++) {
				kline =new KML_LineString();

				kline->ncoord    =(j<pnpart[i]-1 ? ppstrt[i][j+1]-ppstrt[i][j] : pnvert[i]-ppstrt[i][j]);
				kline->coords    =(double (*)[3]) xmalloc(kline->ncoord*3*sizeof(double));
				for (k=0; k<kline->ncoord; k++) {
					kline->coords[k][0]=lon      [ppstrt[i][j]+k];
					kline->coords[k][1]=lat      [ppstrt[i][j]+k];
					kline->coords[k][2]=pshapz[i][ppstrt[i][j]+k];
				}

				(kmulti->geometry  )->AddObject((Object*)kline);
				kline =NULL;
			}

			xfree((void**)&lon);
			xfree((void**)&lat);

			(kplace->geometry  )->AddObject((Object*)kmulti);
			kmulti=NULL;
			(kfold ->feature   )->AddObject((Object*)kplace);
			kplace=NULL;
		}

/*  polygon types  */

		else if (pstype[i] == SHPT_POLYGON ||
				 pstype[i] == SHPT_POLYGONZ ||
				 pstype[i] == SHPT_POLYGONM) {
			_printf_(true,"Warning -- Shape %d of type \"%s\" will be ignored.\n",
					 i,SHPTypeName( pstype[i] ));
			continue;

/*  polygon with multiple holes  */

	if (holes) {
		i=0;
		kplace=new KML_Placemark();
		sprintf(kplace->name      ,"Polygon with Holes");
		kplace->visibility=true;
		sprintf(kplace->styleurl  ,"#BlackLineRandomPoly");

		kpoly =new KML_Polygon();
		kring =new KML_LinearRing();

		lat=(double *) xmalloc(pnvert[i]*sizeof(double));
		lon=(double *) xmalloc(pnvert[i]*sizeof(double));
		Xy2llx(lat,lon,pshapx[i],pshapy[i],pnvert[i],sgn,cm,sp);

		kring->ncoord    =pnvert[i];
		kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
		for (j=0; j<pnvert[i]; j++) {
			kring->coords[j][0]=lon[j];
			kring->coords[j][1]=lat[j];
			kring->coords[j][2]=0.;
		}
		xfree((void**)&lon);
		xfree((void**)&lat);

		(kpoly ->outer     )->AddObject((Object*)kring);
		kring =NULL;

		for (i=1; i<nshap; i++) {
			if (!closed[i]) {
				_printf_(true,"Warning -- Inner profile %d is not closed with \"holes\" specified, so it will be ignored.\n",i+1);
				continue;
			}

			kring =new KML_LinearRing();

			lat=(double *) xmalloc(pnvert[i]*sizeof(double));
			lon=(double *) xmalloc(pnvert[i]*sizeof(double));
			Xy2llx(lat,lon,pshapx[i],pshapy[i],pnvert[i],sgn,cm,sp);
			kring->ncoord    =pnvert[i];
			kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
			for (j=0; j<pnvert[i]; j++) {
				kring->coords[j][0]=lon[j];
				kring->coords[j][1]=lat[j];
				kring->coords[j][2]=0.;
			}
			xfree((void**)&lon);
			xfree((void**)&lat);

			(kpoly ->inner     )->AddObject((Object*)kring);
			kring =NULL;
		}

		(kplace->geometry  )->AddObject((Object*)kpoly);
		kpoly =NULL;
		(kfold ->feature   )->AddObject((Object*)kplace);
		kplace=NULL;
	}

/*  multiple polygons or linestrings  */

	else {
		for (i=0; i<nshap; i++) {
			kplace=new KML_Placemark();

			if (closed[i]) {
				sprintf(kplace->name      ,"Polygon %d",i+1);
				kplace->visibility=true;
				sprintf(kplace->styleurl  ,"#BlackLineRandomPoly");

				kpoly =new KML_Polygon();
				kring =new KML_LinearRing();

				lat=(double *) xmalloc(pnvert[i]*sizeof(double));
				lon=(double *) xmalloc(pnvert[i]*sizeof(double));
				Xy2llx(lat,lon,pshapx[i],pshapy[i],pnvert[i],sgn,cm,sp);

				kring->ncoord    =pnvert[i];
				kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
				for (j=0; j<pnvert[i]; j++) {
					kring->coords[j][0]=lon[j];
					kring->coords[j][1]=lat[j];
					kring->coords[j][2]=0.;
				}
				xfree((void**)&lon);
				xfree((void**)&lat);

				(kpoly ->outer     )->AddObject((Object*)kring);
				kring =NULL;

				(kplace->geometry  )->AddObject((Object*)kpoly);
				kpoly =NULL;
			}

			(kfold ->feature   )->AddObject((Object*)kplace);
			kplace=NULL;
		}
	}
		}

/*  multipoint types  */

		else if (pstype[i] == SHPT_MULTIPOINT ||
				 pstype[i] == SHPT_MULTIPOINTZ ||
				 pstype[i] == SHPT_MULTIPOINTM) {
			kplace=new KML_Placemark();

			sprintf(kplace->name      ,"Shape:%d (%s)  nVertices=%d, nParts=%d",
					i,SHPTypeName(pstype[i]),pnvert[i],pnpart[i]);
			kplace->visibility=true;
			sprintf(kplace->styleurl  ,"#RandomLineEmptyPoly");

			if (pnpart[i] > 0)
				_printf_(true,"Warning -- Shape %d of type \"%s\" should not have %d > 0 parts.\n",
						 i,SHPTypeName( pstype[i] ),pnpart[i]);

			kmulti=new KML_MultiGeometry();

			lat=(double *) xmalloc(pnvert[i]*sizeof(double));
			lon=(double *) xmalloc(pnvert[i]*sizeof(double));
			if (sgn) {
				Xy2llx(lat,lon,pshapx[i],pshapy[i],pnvert[i],sgn,cm,sp);
			}
			else  {
				memcpy(lon,pshapx[i],pnvert[i]*sizeof(double));
				memcpy(lat,pshapy[i],pnvert[i]*sizeof(double));
			}

			for (j=0; j<pnvert[i]; j++) {
				kpoint=new KML_Point();

				kpoint->coords[0]=lon      [j];
				kpoint->coords[1]=lat      [j];
				kpoint->coords[2]=pshapz[i][j];

				(kmulti->geometry  )->AddObject((Object*)kpoint);
				kpoint=NULL;
			}

			xfree((void**)&lon);
			xfree((void**)&lat);

			(kplace->geometry  )->AddObject((Object*)kmulti);
			kmulti=NULL;
			(kfold ->feature   )->AddObject((Object*)kplace);
			kplace=NULL;
		}

/*  multipatch types  */

		else if (pstype[i] == SHPT_MULTIPATCH) {
		}

/*  unknown type  */

		else {
			_printf_(true,"Warning -- Shape %d of type \"%s\" will be ignored.\n",
					 i,SHPTypeName( pstype[i] ));
		}

	}

/*  assemble the rest of the kml hierarchy  */

	(kdoc ->feature   )->AddObject((Object*)kfold);
	kfold=NULL;
	(kfile->kmlobj    )->AddObject((Object*)kdoc);
	kdoc =NULL;

/*  write kml file  */

	_printf_(true,"Writing kml document to file.\n");
	fid=fopen(filkml,"w");
	fprintf(fid,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	kfile->Write(fid,indent);
	fclose(fid);

	delete kfile;
	for (i=nshap-1; i>=0; i--) {
		xfree((void**)&(pshapm[i]));
		xfree((void**)&(pshapz[i]));
		xfree((void**)&(pshapy[i]));
		xfree((void**)&(pshapx[i]));
	}
	xfree((void**)&pshapm);
	xfree((void**)&pshapz);
	xfree((void**)&pshapy);
	xfree((void**)&pshapx);
	xfree((void**)&pnvert);
	for (i=nshap-1; i>=0; i--) {
		xfree((void**)&(pptype[i]));
		xfree((void**)&(ppstrt[i]));
	}
	xfree((void**)&pptype);
	xfree((void**)&ppstrt);
	xfree((void**)&pnpart);
	xfree((void**)&pstype);

	clock1=clock();
	time1 =time(NULL);
	_printf_(true,"Shp2Kmlx Module -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock1-clock0))/CLOCKS_PER_SEC,difftime(time1,time0));

	return(iret);

	#endif //ifdef _HAVE_SHAPELIB_
}

