function grids=UpdateGridPosition(md,grids,bed,thickness);
%UPDATEGRIDPOSITION - update the position of the nodes after a time step
%
%   Update grid z field, using new bed and new thickness, and using
%   md.numlayers of extrusion.
%
%   Usage:
%      grids=UpdateGridPosition(md,grids,bed,thickness)

count2d=[1:md.numberofgrids2d]';

for i=1:md.numlayers,
	count=count2d+(i-1)*md.numberofgrids2d;
	for j=1:size(count,1),
		grids(count(j)).grid.z=bed(count(j))+grids(count(j)).grid.s*thickness(count(j));
	end
end
