/*!\file Shp2Kmlx
 * \brief shp to kml conversion routines.
 */

#include "./Shp2Kmlx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

int Shp2Kmlx(char* filshp,char* filkml,
			 int sgn,
			 bool holes){

	#ifdef _HAVE_SHAPELIB_ //only works if Shapelib library has been compiled in.
	
	double  cm,sp;

	Xy2lldef(&cm,&sp,sgn);

	return(Shp2Kmlx(filshp,filkml,
					sgn,cm,sp,
					holes));

	#endif //ifdef _HAVE_SHAPELIB_
}

int Shp2Kmlx(char* filshp,char* filkml,
			 int sgn,double cm,double sp,
			 bool holes){

	#ifdef _HAVE_SHAPELIB_ //only works if Shapelib library has been compiled in.
	
	int     i,j,iret=0;
	int     lwidth=1;
	double  popac=0.50;
	int     nprof;
	int     *pnvert=NULL,*pptype=NULL;
	double  **pprofx=NULL,**pprofy=NULL,**pprofz=NULL,**pprofm=NULL;
	bool    *closed=NULL;
	double  *lat=NULL,*lon=NULL;

	SHPHandle   hSHP;
	int     nShapeType, nEntities, iPart, bValidate = 0,nInvalidCount=0;
	const char  *pszPlus;
	double  adfMinBound[4], adfMaxBound[4];

	char    indent[81]="";
	KML_File*          kfile =NULL;
	KML_Document*      kdoc  =NULL;
	KML_Style*         kstyle=NULL;
	KML_LineStyle*     klsty =NULL;
	KML_PolyStyle*     kpsty =NULL;
	KML_Folder*        kfold =NULL;
	KML_Placemark*     kplace=NULL;
	KML_Polygon*       kpoly =NULL;
	KML_LinearRing*    kring =NULL;
	KML_LineString*    kline =NULL;

	FILE*   fid=NULL;

	clock_t clock0,clock1;
	time_t  time0, time1;

	clock0=clock();
	time0 =time(NULL);
	_printf_(true,"\nShp2Kmlx Module -- %s",ctime(&time0));

/*  note that much of the following code is taken from shpdump.c in shapelib.  */

/*  open shp/shx files  */

	hSHP = SHPOpen( filshp, "rb" );
	if (!hSHP) _error_("Error opening shp/shx files.");

/*  read header and print out file bounds  */

	SHPGetInfo( hSHP, &nEntities, &nShapeType, adfMinBound, adfMaxBound );

	printf( "Shapefile Type: %s   # of Shapes: %d\n\n",
			SHPTypeName( nShapeType ), nEntities );

	printf( "File Bounds: (%12.3f,%12.3f,%g,%g)\n"
			"         to  (%12.3f,%12.3f,%g,%g)\n",
			adfMinBound[0],
			adfMinBound[1],
			adfMinBound[2],
			adfMinBound[3],
			adfMaxBound[0],
			adfMaxBound[1],
			adfMaxBound[2],
			adfMaxBound[3] );

	nprof=nEntities;
	pnvert=(int *) xmalloc(nprof*sizeof(int));
	pptype=(int *) xmalloc(nprof*sizeof(int));
	pprofx=(double **) xmalloc(nprof*sizeof(double *));
	pprofy=(double **) xmalloc(nprof*sizeof(double *));
	pprofz=(double **) xmalloc(nprof*sizeof(double *));
	pprofm=(double **) xmalloc(nprof*sizeof(double *));

	if (!DomainOutlineRead(&nprof,&pnvert,&pprofx,&pprofy,&closed,filshp,false))

/*  loop over the list of shapes  */

	for( i = 0; i < nEntities; i++ )
	{
//	int     j;
		SHPObject   *psShape;

	psShape = SHPReadObject( hSHP, i );

	printf( "\nShape:%d (%s)  nVertices=%d, nParts=%d\n"
				"  Bounds:(%12.3f,%12.3f, %g, %g)\n"
				"      to (%12.3f,%12.3f, %g, %g)\n",
			i, SHPTypeName(psShape->nSHPType),
				psShape->nVertices, psShape->nParts,
				psShape->dfXMin, psShape->dfYMin,
				psShape->dfZMin, psShape->dfMMin,
				psShape->dfXMax, psShape->dfYMax,
				psShape->dfZMax, psShape->dfMMax );

	pnvert[i]=psShape->nVertices;
	pptype[i]=psShape->nSHPType;
	pprofx[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
	pprofy[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
	pprofz[i]=(double *) xmalloc(pnvert[i]*sizeof(double));
	pprofm[i]=(double *) xmalloc(pnvert[i]*sizeof(double));

	for( j = 0, iPart = 1; j < psShape->nVertices; j++ )
	{
			const char  *pszPartType = "";

			if( j == 0 && psShape->nParts > 0 )
				pszPartType = SHPPartTypeName( psShape->panPartType[0] );

		if( iPart < psShape->nParts
				&& psShape->panPartStart[iPart] == j )
		{
				pszPartType = SHPPartTypeName( psShape->panPartType[iPart] );
		iPart++;
		pszPlus = "+";
		}
		else
			pszPlus = " ";

//		printf("   %s (%12.3f,%12.3f, %g, %g) %s \n",
//				   pszPlus,
//				   psShape->padfX[j],
//				   psShape->padfY[j],
//				   psShape->padfZ[j],
//				   psShape->padfM[j],
//				   pszPartType );

		pprofx[i][j]=psShape->padfX[j];
		pprofy[i][j]=psShape->padfY[j];
		pprofz[i][j]=psShape->padfZ[j];
		pprofm[i][j]=psShape->padfM[j];
	}

		if( bValidate )
		{
			int nAltered = SHPRewindObject( hSHP, psShape );

			if( nAltered > 0 )
			{
				printf( "  %d rings wound in the wrong direction.\n",
						nAltered );
				nInvalidCount++;
			}
		}

		SHPDestroyObject( psShape );
	}

/*  close shp/shx files  */

	SHPClose( hSHP );
	return(iret);

/*  read shp file  */

	if (!DomainOutlineRead(&nprof,&pnvert,&pprofx,&pprofy,&closed,filshp,false))
		_error_("Error reading shp file.");

/*  construct kml file  */

	kfile =new KML_File();
	kfile->AddAttrib("xmlns","http://www.opengis.net/kml/2.2");

/*  construct kml document  */

	kdoc  =new KML_Document();
	sprintf(kdoc->name      ,"Shp2Kmlx Module -- %s",ctime(&time0));
	kdoc->open      =1;

/*  construct style templates for defaults  */

	klsty =new KML_LineStyle();
	sprintf(klsty->color     ,"ff000000");
	sprintf(klsty->colormode ,"normal");
	klsty->width     =lwidth;
	kpsty =new KML_PolyStyle();
	sprintf(kpsty->color     ,"%02xffffff",(int)floor(popac*255+0.5));
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	kstyle->AddAttrib("id","BlackLineRandomPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	klsty =new KML_LineStyle();
	sprintf(klsty->color     ,"ff000000");
	sprintf(klsty->colormode ,"normal");
	klsty->width     ,lwidth;
	kpsty =new KML_PolyStyle();
	sprintf(kpsty->color     ,"00ffffff");
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	kstyle->AddAttrib("id","BlackLineEmptyPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

	klsty =new KML_LineStyle();
	sprintf(klsty->color     ,"%02xffffff",(int)floor(popac*255+0.5));
	sprintf(klsty->colormode ,"random");
	klsty->width     =lwidth*2;
	kpsty =new KML_PolyStyle();
	sprintf(kpsty->color     ,"00ffffff");
	sprintf(kpsty->colormode ,"random");
	kstyle=new KML_Style();
	kstyle->AddAttrib("id","RandomLineEmptyPoly");
	kstyle->line      =klsty;
	kstyle->poly      =kpsty;
	(kdoc->style     )->AddObject((Object*)kstyle);

/*  construct kml folder for polygons  */

	kfold =new KML_Folder();
	sprintf(kfold->name      ,"Profiles translated from file \"%s\".",filshp);
	kfold->open      =1;

/*  polygon with multiple holes  */

	if (holes && nprof && !closed[0]) {
		_printf_(true,"Warning -- Outer profile is not closed, so \"holes\" option will be ignored.\n");
		holes=false;
	}

	if (holes) {
		i=0;
		kplace=new KML_Placemark();
		sprintf(kplace->name      ,"Polygon with Holes");
		kplace->visibility=true;
		sprintf(kplace->styleurl  ,"#BlackLineRandomPoly");

		kpoly =new KML_Polygon();
		kring =new KML_LinearRing();

		lat=(double *) xmalloc(pnvert[i]*sizeof(double));
		lon=(double *) xmalloc(pnvert[i]*sizeof(double));
		Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);

		kring->ncoord    =pnvert[i];
		kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
		for (j=0; j<pnvert[i]; j++) {
			kring->coords[j][0]=lon[j];
			kring->coords[j][1]=lat[j];
			kring->coords[j][2]=0.;
		}
		xfree((void**)&lon);
		xfree((void**)&lat);

		(kpoly ->outer     )->AddObject((Object*)kring);
		kring =NULL;

		for (i=1; i<nprof; i++) {
			if (!closed[i]) {
				_printf_(true,"Warning -- Inner profile %d is not closed with \"holes\" specified, so it will be ignored.\n",i+1);
				continue;
			}

			kring =new KML_LinearRing();

			lat=(double *) xmalloc(pnvert[i]*sizeof(double));
			lon=(double *) xmalloc(pnvert[i]*sizeof(double));
			Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);
			kring->ncoord    =pnvert[i];
			kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
			for (j=0; j<pnvert[i]; j++) {
				kring->coords[j][0]=lon[j];
				kring->coords[j][1]=lat[j];
				kring->coords[j][2]=0.;
			}
			xfree((void**)&lon);
			xfree((void**)&lat);

			(kpoly ->inner     )->AddObject((Object*)kring);
			kring =NULL;
		}

		(kplace->geometry  )->AddObject((Object*)kpoly);
		kpoly =NULL;
		(kfold ->feature   )->AddObject((Object*)kplace);
		kplace=NULL;
	}

/*  multiple polygons or linestrings  */

	else {
		for (i=0; i<nprof; i++) {
			kplace=new KML_Placemark();

			if (closed[i]) {
				sprintf(kplace->name      ,"Polygon %d",i+1);
				kplace->visibility=true;
				sprintf(kplace->styleurl  ,"#BlackLineRandomPoly");

				kpoly =new KML_Polygon();
				kring =new KML_LinearRing();

				lat=(double *) xmalloc(pnvert[i]*sizeof(double));
				lon=(double *) xmalloc(pnvert[i]*sizeof(double));
				Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);

				kring->ncoord    =pnvert[i];
				kring->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
				for (j=0; j<pnvert[i]; j++) {
					kring->coords[j][0]=lon[j];
					kring->coords[j][1]=lat[j];
					kring->coords[j][2]=0.;
				}
				xfree((void**)&lon);
				xfree((void**)&lat);

				(kpoly ->outer     )->AddObject((Object*)kring);
				kring =NULL;

				(kplace->geometry  )->AddObject((Object*)kpoly);
				kpoly =NULL;
			}

			else {
				sprintf(kplace->name      ,"LineString %d",i+1);
				kplace->visibility=true;
				sprintf(kplace->styleurl  ,"#RandomLineEmptyPoly");

				kline =new KML_LineString();

				lat=(double *) xmalloc(pnvert[i]*sizeof(double));
				lon=(double *) xmalloc(pnvert[i]*sizeof(double));
				Xy2llx(lat,lon,pprofx[i],pprofy[i],pnvert[i],sgn,cm,sp);

				kline->ncoord    =pnvert[i];
				kline->coords    =(double (*)[3]) xmalloc(pnvert[i]*3*sizeof(double));
				for (j=0; j<pnvert[i]; j++) {
					kline->coords[j][0]=lon[j];
					kline->coords[j][1]=lat[j];
					kline->coords[j][2]=0.;
				}
				xfree((void**)&lon);
				xfree((void**)&lat);

				(kplace->geometry  )->AddObject((Object*)kline);
				kline =NULL;
			}

			(kfold ->feature   )->AddObject((Object*)kplace);
			kplace=NULL;
		}
	}

/*  assemble the rest of the kml hierarchy  */

	(kdoc ->feature   )->AddObject((Object*)kfold);
	kfold=NULL;
	(kfile->kmlobj    )->AddObject((Object*)kdoc);
	kdoc =NULL;

/*  write kml file  */

	_printf_(true,"Writing kml document to file.\n");
	fid=fopen(filkml,"w");
	fprintf(fid,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	kfile->Write(fid,indent);
	fclose(fid);

	delete kfile;
	for (i=nprof-1; i>=0; i--) {
		xfree((void**)&(pprofy[i]));
		xfree((void**)&(pprofx[i]));
	}
	xfree((void**)&pnvert);

	clock1=clock();
	time1 =time(NULL);
	_printf_(true,"Shp2Kmlx Module -- %f CPU seconds; %f elapsed seconds.\n\n",
			 ((double)(clock1-clock0))/CLOCKS_PER_SEC,difftime(time1,time0));

	return(iret);

	#endif //ifdef _HAVE_SHAPELIB_
}

