function result=testscheckmisfit(misfit),
%TESTSCHECKMISFIT- check the misfit requested 
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   to be sure that the misfit resquested is consistent with the model type.
%   It returns 1 of the misfit is consistent, 0 else.
%   The misfit must be a string.
%
%   Usage:
%      result=testscheckmisfit(misfit)
%
%   Example:
%      result=testscheckmisfit('absolute')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE, TESTSCHECKSOLUTION

result=ismember({misfit}{'absolute','relative','logarithmic'};
