/* \file ModuleBoot.cpp
 * \brief Carry out operations needed to boot, for example, petsc, MPI, plapack, etc ... 
 * at the beginning of a module
 */

#include "../../toolkits/toolkits.h"

int my_rank;
int num_procs;

int ModuleBoot(void){
	
	/*Declare my_rank and num_procs global variables!: */
	my_rank=0;
	num_procs=1;

	/*Some test for MPI_Init crash with mpich2 1.4 on larsen, just ignore*/
	#if _PETSC_MAJOR_ == 3 && _PETSC_MINOR_ < 1
	if(0){
		int              mp_init = 0;
		PetscErrorCode   ierr;
		extern PetscBool PetscBeganMPI;
		MPI_Initialized(&mp_init); 
		if(mp_init!=1){
			MPI_Init(NULL,NULL); 
			PetscBeganMPI = PETSC_TRUE;
			ierr=PetscInitializeNoArguments();CHKERRQ(ierr);
		} 
	}
	else if (0){
		PetscErrorCode   ierr;
		PetscBool flg;
		ierr=PetscInitialized(&flg);CHKERRQ(ierr);
		if(flg){
			extern PetscBool PetscBeganMPI;
			PetscBeganMPI = PETSC_FALSE;
			ierr=PetscFinalize();CHKERRQ(ierr);
		}
		ierr=PetscInitializeNoArguments();CHKERRQ(ierr);
		ierr=PetscPopSignalHandler();CHKERRQ(ierr);
	}
	#endif

	/*Initialize Petsc: */
	PetscInitializeNoArguments();

	return 1;
}
