function updatearchive(varargin)
%UPDATEARCHIVE - update the tests archives in 'tests/Verification'
%
%   This function updates all the archive files of the Verification directory on ISSM.
%   All the archive files are saved in the appropriate directory but no one is commited.
%   If you want to do so, just commit the updated files. A specific package can be 
%   given in input only this package will be tested
%
%  Usage:
%      updatearchive(varargin)
%
%   Example:
%      updatearchive;
%      updatearchive({'ice'});
%      updatearchive({'cielo_serial','cielo_parallel'});
%      updatearchive({'ice'},{'prognostic','diagnostic'});

%check arguments
if (nargin>2)
	help updatearchive
	error('updatearchive error message: bad usage');
end

%use ISSM_DIR generated by startup.m
global ISSM_DIR

%Go to Test directory
eval(['cd ' ISSM_DIR '/test/']);

%Run all verification tests
cd Verification

%Get a list of the test decks
[status,list]=system('ls -l | grep -v CVS | awk ''{printf("%s|",$9);}'' '); %only works on *nix systems.
list=strsplit(list,'|');

%Get packages
if nargin,
	packages=varargin{1};
else
	packages={'macayeal','ice','cielo_serial','cielo_parallel'};
end

%Go through list of decks, and run the deck updatearchive.m files package by package.
for i=1:length(packages),
	for j=2:length(list)-1,
		eval(['cd ' list{j}]);
		if nargin==2,
			updatearchive(packages(i),varargin(2));
		else
			updatearchive(packages(i));
		end
		cd ..
	end
end
