#!/usr/bin/env python
# STARTUP - Python startup script
#
#  startup.py is a script run by python at the beginning of a session, just before
#  handing over the prompt to the user if the environment variable PYTHONSTARTUP is defined:
#  export PYTHONSTARTUP=$ISSM_TIER/startup.py
#  This startup script should be run by users before trying to use ISSM.

import os,sys

#Recover ISSM_TIER, ISSM_DIR  and USERNAME
ISSM_TIER=os.getenv('ISSM_TIER')
USERNAME =os.getenv('USER')
if(ISSM_TIER==None):
	raise NameError('"ISSM_TIER" environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!')

#Now add all issm code paths necessary to run issm smoothly. 
#We capture the error output, so that we can warn the user to update 
#the variable ISSM_TIER in this file, in case it is not correctly setup. 

#ISSM path
sys.path.append(ISSM_TIER+'/src/py')
sys.path.append(ISSM_TIER+'/src/py/classes')
sys.path.append(ISSM_TIER+'/src/py/modules/TriMesh')
sys.path.append(ISSM_TIER+'/src/py/modules/hello')
from model import *

print "\n  To get started with ISSM, type issmdoc at the command prompt.\n\n"
