%
%  plot a normal probability plot of the responses.
%
%  []=plot_normplot(dresp)
%
%  where the required input is:
%    dresp         (structure array, responses)
%
%  the required fields of dresp are:
%    descriptor    (char, description)
%    sample        (double vector, list of samples)
%
%  for each response in the input array, this function plots
%  a matlab normal probability plot of the list of samples
%  and annotates it with the description.  the lists of samples
%  need not all be the same length.
%
%  this data would typically be contained in the dakota tabular
%  output file and read by dakota_out_parse.
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=plot_normplot(dresp)

if ~nargin
    help plot_normplot
    return
end

%%  assemble the data into a matrix

desc=cell (1,length(dresp));
for i=1:length(dresp)
    ldata(i)=length(dresp(i).sample);
end
data=zeros(max(ldata),length(dresp));

for i=1:length(dresp)
    desc(i)=cellstr(dresp(i).descriptor);
    data(1:ldata(i),i)=dresp(i).sample;
end

%%  draw the plot

%  draw normal probability plot

normplot(data)
ax1=gca;

%  add the annotation

title('Normal Probability Plot of Variables and/or Responses')
xlabel('Value')
ylabel('Probability')

hleg1=legend(ax1,desc,'Location','EastOutside',...
             'Orientation','vertical','Interpreter','none');

end
