/*!\file: Inputs.h
 * \brief prototypes for Inputs.h
 */ 

#ifndef _CONTAINER_INPUTS_H_
#define  _CONTAINER_INPUTS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Input;
class Node;
class GaussTria;
class GaussPenta;

class Inputs: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Inputs();
		Inputs(int enum_type);
		~Inputs();

		/*}}}*/
		/*numerics: {{{1*/
		int     AddInput(Input* in_input);
		void    ChangeEnum(int enumtype,int new_enumtype);
		void    ConstrainMin(int constrain_enum, double minimum);
		int     DeleteInput(int enum_type);
		void    DuplicateInput(int original_enum,int new_enum);
		Input*  GetInput(int enum_name);
		Inputs* SpawnTriaInputs(int* indices);
		void    AXPY(int MeshYEnum, double scalar, int MeshXEnum);
		double  InfinityNorm(int enumtype);
		double  Max(int enumtype);
		double  MaxAbs(int enumtype);
		double  Min(int enumtype);
		double  MinAbs(int enumtype);
		
		void GetInputAverage(double* pvalue, int enum_type);
		void GetInputValue(bool* pvalue,int enum_type);
		void GetInputValue(int* pvalue,int enum_type);
		void GetInputValue(double* pvalue,int enum_type);

		void Configure(Parameters* parameters);
		/*}}}*/

};

#endif //ifndef _INPUTS_H_
